/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.function.RunnableWithException;

@Internal
public final class ExceptionUtils {
    public static final String STRINGIFIED_NULL_EXCEPTION = "(null)";

    public static String stringifyException(Throwable e) {
        if (e == null) {
            return STRINGIFIED_NULL_EXCEPTION;
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            e.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable t) {
            return e.getClass().getName() + " (error while printing stack trace)";
        }
    }

    public static boolean isJvmFatalError(Throwable t) {
        return t instanceof InternalError || t instanceof UnknownError || t instanceof ThreadDeath;
    }

    public static boolean isJvmFatalOrOutOfMemoryError(Throwable t) {
        return ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError;
    }

    public static void rethrowIfFatalError(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t)) {
            throw (Error)t;
        }
    }

    public static void rethrowIfFatalErrorOrOOM(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError) {
            throw (Error)t;
        }
    }

    public static <T extends Throwable> T firstOrSuppressed(T newException, @Nullable T previous) {
        Preconditions.checkNotNull(newException, "newException");
        if (previous == null) {
            return newException;
        }
        previous.addSuppressed(newException);
        return previous;
    }

    public static void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void rethrow(Throwable t, String parentMessage) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(parentMessage, t);
    }

    public static void rethrowException(Throwable t, String parentMessage) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(parentMessage, t);
    }

    public static void rethrowException(Throwable t) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(t.getMessage(), t);
    }

    public static void tryRethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static void rethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    public static <T extends Throwable> Optional<T> findThrowable(Throwable throwable, Class<T> searchType) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!searchType.isAssignableFrom(t.getClass())) continue;
            return Optional.of(searchType.cast(t));
        }
        return Optional.empty();
    }

    public static Optional<Throwable> findThrowable(Throwable throwable, Predicate<Throwable> predicate) {
        if (throwable == null || predicate == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!predicate.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static Optional<Throwable> findThrowableWithMessage(Throwable throwable, String searchMessage) {
        if (throwable == null || searchMessage == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t.getMessage() == null || !t.getMessage().contains(searchMessage)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static Throwable stripExecutionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, ExecutionException.class);
    }

    public static Throwable stripCompletionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, CompletionException.class);
    }

    public static Throwable stripException(Throwable throwableToStrip, Class<? extends Throwable> typeToStrip) {
        while (typeToStrip.isAssignableFrom(throwableToStrip.getClass()) && throwableToStrip.getCause() != null) {
            throwableToStrip = throwableToStrip.getCause();
        }
        return throwableToStrip;
    }

    public static void tryDeserializeAndThrow(Throwable throwable, ClassLoader classLoader) throws Throwable {
        Throwable current = throwable;
        while (!(current instanceof SerializedThrowable) && current.getCause() != null) {
            current = current.getCause();
        }
        if (current instanceof SerializedThrowable) {
            throw ((SerializedThrowable)current).deserializeError(classLoader);
        }
        throw throwable;
    }

    public static void checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void suppressExceptions(RunnableWithException action) {
        block3: {
            try {
                action.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (!ExceptionUtils.isJvmFatalError(t)) break block3;
                ExceptionUtils.rethrow(t);
            }
        }
    }

    private ExceptionUtils() {
    }
}

