/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import java.util.EnumMap;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;

public class StateTtlConfig
implements Serializable {
    private static final long serialVersionUID = -7592693245044289793L;
    public static final StateTtlConfig DISABLED = StateTtlConfig.newBuilder(Time.milliseconds(Long.MAX_VALUE)).setUpdateType(UpdateType.Disabled).build();
    private final UpdateType updateType;
    private final StateVisibility stateVisibility;
    private final TimeCharacteristic timeCharacteristic;
    private final Time ttl;
    private final CleanupStrategies cleanupStrategies;

    private StateTtlConfig(UpdateType updateType, StateVisibility stateVisibility, TimeCharacteristic timeCharacteristic, Time ttl, CleanupStrategies cleanupStrategies) {
        this.updateType = Preconditions.checkNotNull(updateType);
        this.stateVisibility = Preconditions.checkNotNull(stateVisibility);
        this.timeCharacteristic = Preconditions.checkNotNull(timeCharacteristic);
        this.ttl = Preconditions.checkNotNull(ttl);
        this.cleanupStrategies = cleanupStrategies;
        Preconditions.checkArgument(ttl.toMilliseconds() > 0L, "TTL is expected to be positive");
    }

    @Nonnull
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @Nonnull
    public StateVisibility getStateVisibility() {
        return this.stateVisibility;
    }

    @Nonnull
    public Time getTtl() {
        return this.ttl;
    }

    @Nonnull
    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public boolean isEnabled() {
        return this.updateType != UpdateType.Disabled;
    }

    @Nonnull
    public CleanupStrategies getCleanupStrategies() {
        return this.cleanupStrategies;
    }

    public String toString() {
        return "StateTtlConfig{updateType=" + (Object)((Object)this.updateType) + ", stateVisibility=" + (Object)((Object)this.stateVisibility) + ", timeCharacteristic=" + (Object)((Object)this.timeCharacteristic) + ", ttl=" + this.ttl + '}';
    }

    @Nonnull
    public static Builder newBuilder(@Nonnull Time ttl) {
        return new Builder(ttl);
    }

    public static class CleanupStrategies
    implements Serializable {
        private static final long serialVersionUID = -1617740467277313524L;
        final EnumMap<Strategies, CleanupStrategy> strategies = new EnumMap(Strategies.class);

        public boolean inFullSnapshot() {
            return this.strategies.containsKey((Object)Strategies.FULL_STATE_SCAN_SNAPSHOT);
        }

        static interface CleanupStrategy
        extends Serializable {
        }

        static enum Strategies {
            FULL_STATE_SCAN_SNAPSHOT;

        }
    }

    public static class Builder {
        private UpdateType updateType = UpdateType.OnCreateAndWrite;
        private StateVisibility stateVisibility = StateVisibility.NeverReturnExpired;
        private TimeCharacteristic timeCharacteristic = TimeCharacteristic.ProcessingTime;
        private Time ttl;
        private CleanupStrategies cleanupStrategies = new CleanupStrategies();

        public Builder(@Nonnull Time ttl) {
            this.ttl = ttl;
        }

        @Nonnull
        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        @Nonnull
        public Builder updateTtlOnCreateAndWrite() {
            return this.setUpdateType(UpdateType.OnCreateAndWrite);
        }

        @Nonnull
        public Builder updateTtlOnReadAndWrite() {
            return this.setUpdateType(UpdateType.OnReadAndWrite);
        }

        @Nonnull
        public Builder setStateVisibility(@Nonnull StateVisibility stateVisibility) {
            this.stateVisibility = stateVisibility;
            return this;
        }

        @Nonnull
        public Builder returnExpiredIfNotCleanedUp() {
            return this.setStateVisibility(StateVisibility.ReturnExpiredIfNotCleanedUp);
        }

        @Nonnull
        public Builder neverReturnExpired() {
            return this.setStateVisibility(StateVisibility.NeverReturnExpired);
        }

        @Nonnull
        public Builder setTimeCharacteristic(@Nonnull TimeCharacteristic timeCharacteristic) {
            this.timeCharacteristic = timeCharacteristic;
            return this;
        }

        @Nonnull
        public Builder useProcessingTime() {
            return this.setTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        }

        @Nonnull
        public Builder cleanupFullSnapshot() {
            this.cleanupStrategies.strategies.put(CleanupStrategies.Strategies.FULL_STATE_SCAN_SNAPSHOT, new CleanupStrategies.CleanupStrategy(){});
            return this;
        }

        @Nonnull
        public Builder setTtl(@Nonnull Time ttl) {
            this.ttl = ttl;
            return this;
        }

        @Nonnull
        public StateTtlConfig build() {
            return new StateTtlConfig(this.updateType, this.stateVisibility, this.timeCharacteristic, this.ttl, this.cleanupStrategies);
        }
    }

    public static enum TimeCharacteristic {
        ProcessingTime;

    }

    public static enum StateVisibility {
        ReturnExpiredIfNotCleanedUp,
        NeverReturnExpired;

    }

    public static enum UpdateType {
        Disabled,
        OnCreateAndWrite,
        OnReadAndWrite;

    }
}

