/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeDeserializer;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CompatibilityResult<T> {
    private final boolean requiresMigration;
    private final TypeDeserializer<T> convertDeserializer;

    public static <T> CompatibilityResult<T> compatible() {
        return new CompatibilityResult<T>(false, null);
    }

    public static <T> CompatibilityResult<T> requiresMigration(@Nonnull TypeDeserializer<T> convertDeserializer) {
        Preconditions.checkNotNull(convertDeserializer, "Convert deserializer cannot be null.");
        return new CompatibilityResult<T>(true, convertDeserializer);
    }

    public static <T> CompatibilityResult<T> requiresMigration(@Nonnull TypeSerializer<T> convertSerializer) {
        Preconditions.checkNotNull(convertSerializer, "Convert serializer cannot be null.");
        return new CompatibilityResult<T>(true, new TypeDeserializerAdapter<T>(convertSerializer));
    }

    public static <T> CompatibilityResult<T> requiresMigration() {
        return new CompatibilityResult<T>(true, null);
    }

    private CompatibilityResult(boolean requiresMigration, TypeDeserializer<T> convertDeserializer) {
        this.requiresMigration = requiresMigration;
        this.convertDeserializer = convertDeserializer;
    }

    public TypeDeserializer<T> getConvertDeserializer() {
        return this.convertDeserializer;
    }

    public boolean isRequiresMigration() {
        return this.requiresMigration;
    }
}

