/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TypeSerializerSchemaCompatibility<T> {
    private final Type resultType;

    public static <T> TypeSerializerSchemaCompatibility<T> compatibleAsIs() {
        return new TypeSerializerSchemaCompatibility<T>(Type.COMPATIBLE_AS_IS, null);
    }

    public static <T> TypeSerializerSchemaCompatibility<T> compatibleAfterMigration() {
        return new TypeSerializerSchemaCompatibility<T>(Type.COMPATIBLE_AFTER_MIGRATION, null);
    }

    public static <T> TypeSerializerSchemaCompatibility<T> incompatible() {
        return new TypeSerializerSchemaCompatibility<T>(Type.INCOMPATIBLE, null);
    }

    private TypeSerializerSchemaCompatibility(Type resultType, @Nullable TypeSerializer<T> reconfiguredNewSerializer) {
        this.resultType = Preconditions.checkNotNull(resultType);
    }

    public boolean isCompatibleAsIs() {
        return this.resultType == Type.COMPATIBLE_AS_IS;
    }

    public boolean isCompatibleAfterMigration() {
        return this.resultType == Type.COMPATIBLE_AFTER_MIGRATION;
    }

    public boolean isIncompatible() {
        return this.resultType == Type.INCOMPATIBLE;
    }

    static enum Type {
        COMPATIBLE_AS_IS,
        COMPATIBLE_AFTER_MIGRATION,
        INCOMPATIBLE;

    }
}

