/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class EnumSerializer<T extends Enum<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> enumClass;
    private Map<T, Integer> valueToOrdinal;
    private T[] values;

    public EnumSerializer(Class<T> enumClass) {
        this.enumClass = Preconditions.checkNotNull(enumClass);
        Preconditions.checkArgument(Enum.class.isAssignableFrom(enumClass), "not an enum");
        this.values = (Enum[])enumClass.getEnumConstants();
        Preconditions.checkArgument(this.values.length > 0, "cannot use an empty enum");
        this.valueToOrdinal = new HashMap<T, Integer>(this.values.length);
        int i = 0;
        for (T value : this.values) {
            this.valueToOrdinal.put(value, i++);
        }
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public EnumSerializer<T> duplicate() {
        return this;
    }

    @Override
    public T createInstance() {
        return this.values[0];
    }

    @Override
    public T copy(T from) {
        return from;
    }

    @Override
    public T copy(T from, T reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        target.writeInt(this.valueToOrdinal.get(record));
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnumSerializer) {
            EnumSerializer other = (EnumSerializer)obj;
            return other.canEqual(this) && other.enumClass == this.enumClass;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof EnumSerializer;
    }

    @Override
    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.values == null) {
            this.values = (Enum[])this.enumClass.getEnumConstants();
            this.valueToOrdinal = new HashMap<T, Integer>(this.values.length);
            int i = 0;
            for (T value : this.values) {
                this.valueToOrdinal.put(value, i++);
            }
        }
    }

    @Override
    public EnumSerializerConfigSnapshot<T> snapshotConfiguration() {
        return new EnumSerializerConfigSnapshot(this.enumClass, this.values);
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot<?> configSnapshot) {
        EnumSerializerConfigSnapshot config;
        if (configSnapshot instanceof EnumSerializerConfigSnapshot && this.enumClass.equals((config = (EnumSerializerConfigSnapshot)configSnapshot).getTypeClass())) {
            Enum[] reorderedEnumConstants = (Enum[])Array.newInstance(this.enumClass, this.values.length);
            HashMap<T, Integer> rebuiltEnumConstantToOrdinalMap = new HashMap<T, Integer>(this.values.length);
            List<String> previousEnumConstants = config.getEnumConstants();
            if (previousEnumConstants.size() <= this.values.length) {
                for (int i = 0; i < previousEnumConstants.size(); ++i) {
                    String previousEnumConstantStr = previousEnumConstants.get(i);
                    try {
                        T enumConstant = Enum.valueOf(this.enumClass, previousEnumConstantStr);
                        reorderedEnumConstants[i] = enumConstant;
                        rebuiltEnumConstantToOrdinalMap.put(enumConstant, i);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        return CompatibilityResult.requiresMigration();
                    }
                }
            } else {
                return CompatibilityResult.requiresMigration();
            }
            if (this.values.length > previousEnumConstants.size()) {
                int appendedNewOrdinal = previousEnumConstants.size();
                for (T currentEnumConstant : this.values) {
                    if (rebuiltEnumConstantToOrdinalMap.containsKey(currentEnumConstant)) continue;
                    reorderedEnumConstants[appendedNewOrdinal] = currentEnumConstant;
                    rebuiltEnumConstantToOrdinalMap.put(currentEnumConstant, appendedNewOrdinal);
                    ++appendedNewOrdinal;
                }
            }
            this.values = reorderedEnumConstants;
            this.valueToOrdinal = rebuiltEnumConstantToOrdinalMap;
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    @VisibleForTesting
    T[] getValues() {
        return this.values;
    }

    @VisibleForTesting
    Map<T, Integer> getValueToOrdinal() {
        return this.valueToOrdinal;
    }

    public static final class EnumSerializerConfigSnapshot<T extends Enum<T>>
    extends GenericTypeSerializerConfigSnapshot<T> {
        private static final int VERSION = 2;
        private List<String> enumConstants;

        public EnumSerializerConfigSnapshot() {
        }

        public EnumSerializerConfigSnapshot(Class<T> enumClass, T[] enumConstantsArr) {
            super(enumClass);
            this.enumConstants = EnumSerializerConfigSnapshot.buildEnumConstantsList((Enum[])((Enum[])Preconditions.checkNotNull(enumConstantsArr)));
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeInt(this.enumConstants.size());
            for (String enumConstant : this.enumConstants) {
                out.writeUTF(enumConstant);
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            block19: {
                super.read(in);
                if (this.getReadVersion() == 1) {
                    try (DataInputViewStream inViewWrapper = new DataInputViewStream(in);){
                        try {
                            Enum[] legacyEnumConstants = (Enum[])InstantiationUtil.deserializeObject(inViewWrapper, this.getUserCodeClassLoader());
                            this.enumConstants = EnumSerializerConfigSnapshot.buildEnumConstantsList((Enum[])legacyEnumConstants);
                            break block19;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("The requested enum class cannot be found in classpath.", e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IOException("A previously existing enum constant of " + this.getTypeClass().getName() + " no longer exists.", e);
                        }
                    }
                }
                if (this.getReadVersion() == 2) {
                    int numEnumConstants = in.readInt();
                    this.enumConstants = new ArrayList<String>(numEnumConstants);
                    for (int i = 0; i < numEnumConstants; ++i) {
                        this.enumConstants.add(in.readUTF());
                    }
                } else {
                    throw new IOException("Cannot deserialize EnumSerializerConfigSnapshot with version " + this.getReadVersion());
                }
            }
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public int[] getCompatibleVersions() {
            return new int[]{2, 1};
        }

        public List<String> getEnumConstants() {
            return this.enumConstants;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.enumConstants.equals(((EnumSerializerConfigSnapshot)obj).getEnumConstants());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.enumConstants.hashCode();
        }

        private static <T extends Enum<T>> List<String> buildEnumConstantsList(T[] enumConstantsArr) {
            ArrayList<String> res = new ArrayList<String>(enumConstantsArr.length);
            for (T enumConstant : enumConstantsArr) {
                res.add(((Enum)enumConstant).name());
            }
            return res;
        }
    }
}

