/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.FloatValue;

@Internal
public class FloatValueSerializer
extends TypeSerializerSingleton<FloatValue> {
    private static final long serialVersionUID = 1L;
    public static final FloatValueSerializer INSTANCE = new FloatValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public FloatValue createInstance() {
        return new FloatValue();
    }

    @Override
    public FloatValue copy(FloatValue from) {
        return this.copy(from, new FloatValue());
    }

    @Override
    public FloatValue copy(FloatValue from, FloatValue reuse) {
        reuse.setValue(from.getValue());
        return reuse;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(FloatValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public FloatValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new FloatValue(), source);
    }

    @Override
    public FloatValue deserialize(FloatValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeFloat(source.readFloat());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof FloatValueSerializer;
    }

    @Override
    public TypeSerializerSnapshot<FloatValue> snapshotConfiguration() {
        return new FloatValueSerializerSnapshot();
    }

    public static final class FloatValueSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<FloatValue> {
        public FloatValueSerializerSnapshot() {
            super(FloatValueSerializer.class);
        }
    }
}

