/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class ListSerializerSnapshot<T>
implements TypeSerializerSnapshot<List<T>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedElementSerializerSnapshot;

    public ListSerializerSnapshot() {
    }

    public ListSerializerSnapshot(TypeSerializer<T> elementSerializer) {
        this.nestedElementSerializerSnapshot = new CompositeSerializerSnapshot(Preconditions.checkNotNull(elementSerializer));
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public TypeSerializer<List<T>> restoreSerializer() {
        return new ListSerializer(this.nestedElementSerializerSnapshot.getRestoreSerializer(0));
    }

    @Override
    public TypeSerializerSchemaCompatibility<List<T>> resolveSchemaCompatibility(TypeSerializer<List<T>> newSerializer) {
        Preconditions.checkState(this.nestedElementSerializerSnapshot != null);
        if (newSerializer instanceof ListSerializer) {
            ListSerializer serializer = (ListSerializer)newSerializer;
            return this.nestedElementSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), serializer.getElementSerializer());
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedElementSerializerSnapshot.writeCompositeSnapshot(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedElementSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot(in, userCodeClassLoader);
    }
}

