/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class MapSerializerSnapshot<K, V>
implements TypeSerializerSnapshot<Map<K, V>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedKeyValueSerializerSnapshot;

    public MapSerializerSnapshot() {
    }

    public MapSerializerSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        Preconditions.checkNotNull(keySerializer);
        Preconditions.checkNotNull(valueSerializer);
        this.nestedKeyValueSerializerSnapshot = new CompositeSerializerSnapshot(keySerializer, valueSerializer);
    }

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public TypeSerializer<Map<K, V>> restoreSerializer() {
        return new MapSerializer(this.nestedKeyValueSerializerSnapshot.getRestoreSerializer(0), this.nestedKeyValueSerializerSnapshot.getRestoreSerializer(1));
    }

    @Override
    public TypeSerializerSchemaCompatibility<Map<K, V>> resolveSchemaCompatibility(TypeSerializer<Map<K, V>> newSerializer) {
        Preconditions.checkState(this.nestedKeyValueSerializerSnapshot != null);
        if (newSerializer instanceof MapSerializer) {
            MapSerializer serializer = (MapSerializer)newSerializer;
            return this.nestedKeyValueSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), serializer.getKeySerializer(), serializer.getValueSerializer());
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedKeyValueSerializerSnapshot.writeCompositeSnapshot(out);
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedKeyValueSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot(in, userCodeClassLoader);
    }
}

