/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class GlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    public static final String FLINK_CONF_FILENAME = "flink-conf.yaml";
    private static final String[] SENSITIVE_KEYS = new String[]{"password", "secret"};
    public static final String HIDDEN_CONTENT = "******";

    private GlobalConfiguration() {
    }

    public static Configuration loadConfiguration() {
        String configDir = System.getenv("FLINK_CONF_DIR");
        if (configDir == null) {
            return new Configuration();
        }
        return GlobalConfiguration.loadConfiguration(configDir, null);
    }

    public static Configuration loadConfiguration(String configDir) {
        return GlobalConfiguration.loadConfiguration(configDir, null);
    }

    public static Configuration loadConfiguration(String configDir, @Nullable Configuration dynamicProperties) {
        if (configDir == null) {
            throw new IllegalArgumentException("Given configuration directory is null, cannot load configuration");
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            throw new IllegalConfigurationException("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
        }
        File yamlConfigFile = new File(confDirFile, FLINK_CONF_FILENAME);
        if (!yamlConfigFile.exists()) {
            throw new IllegalConfigurationException("The Flink config file '" + yamlConfigFile + "' (" + confDirFile.getAbsolutePath() + ") does not exist.");
        }
        Configuration configuration = GlobalConfiguration.loadYAMLResource(yamlConfigFile);
        if (dynamicProperties != null) {
            configuration.addAll(dynamicProperties);
        }
        return configuration;
    }

    public static Configuration loadConfigurationWithDynamicProperties(Configuration dynamicProperties) {
        String configDir = System.getenv("FLINK_CONF_DIR");
        if (configDir == null) {
            return new Configuration(dynamicProperties);
        }
        return GlobalConfiguration.loadConfiguration(configDir, dynamicProperties);
    }

    private static Configuration loadYAMLResource(File file) {
        Configuration config = new Configuration();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            int lineNo = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNo;
                String[] comments = line.split("#", 2);
                String conf = comments[0].trim();
                if (conf.length() <= 0) continue;
                String[] kv = conf.split(": ", 2);
                if (kv.length == 1) {
                    LOG.warn("Error while trying to split key and value in configuration file " + file + ":" + lineNo + ": \"" + line + "\"");
                    continue;
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (key.length() == 0 || value.length() == 0) {
                    LOG.warn("Error after splitting key and value in configuration file " + file + ":" + lineNo + ": \"" + line + "\"");
                    continue;
                }
                LOG.info("Loading configuration property: {}, {}", (Object)key, (Object)(GlobalConfiguration.isSensitive(key) ? HIDDEN_CONTENT : value));
                config.setString(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
        return config;
    }

    public static boolean isSensitive(String key) {
        Preconditions.checkNotNull(key, "key is null");
        String keyInLower = key.toLowerCase();
        for (String hideKey : SENSITIVE_KEYS) {
            if (keyInLower.length() < hideKey.length() || !keyInLower.contains(hideKey)) continue;
            return true;
        }
        return false;
    }
}

