/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;

@ConfigGroups(groups={@ConfigGroup(name="HighAvailabilityZookeeper", keyPrefix="high-availability.zookeeper")})
@PublicEvolving
public class HighAvailabilityOptions {
    @Documentation.CommonOption(position=40)
    public static final ConfigOption<String> HA_MODE = ConfigOptions.key("high-availability").defaultValue("NONE").withDeprecatedKeys("recovery.mode").withDescription("Defines high-availability mode used for the cluster execution. To enable high-availability, set this mode to \"ZOOKEEPER\" or specify FQN of factory class.");
    public static final ConfigOption<String> HA_CLUSTER_ID = ConfigOptions.key("high-availability.cluster-id").defaultValue("/default").withDeprecatedKeys("high-availability.zookeeper.path.namespace", "recovery.zookeeper.path.namespace").withDescription("The ID of the Flink cluster, used to separate multiple Flink clusters from each other. Needs to be set for standalone clusters but is automatically inferred in YARN and Mesos.");
    @Documentation.CommonOption(position=40)
    public static final ConfigOption<String> HA_STORAGE_PATH = ConfigOptions.key("high-availability.storageDir").noDefaultValue().withDeprecatedKeys("high-availability.zookeeper.storageDir", "recovery.zookeeper.storageDir").withDescription("File system path (URI) where Flink persists metadata in high-availability setups.");
    public static final ConfigOption<String> HA_JOB_MANAGER_PORT_RANGE = ConfigOptions.key("high-availability.jobmanager.port").defaultValue("0").withDeprecatedKeys("recovery.jobmanager.port").withDescription("Optional port (range) used by the job manager in high-availability mode.");
    public static final ConfigOption<String> HA_JOB_DELAY = ConfigOptions.key("high-availability.job.delay").noDefaultValue().withDeprecatedKeys("recovery.job.delay").withDescription("The time before a JobManager after a fail over recovers the current jobs.");
    public static final ConfigOption<String> HA_ZOOKEEPER_QUORUM = ConfigOptions.key("high-availability.zookeeper.quorum").noDefaultValue().withDeprecatedKeys("recovery.zookeeper.quorum").withDescription("The ZooKeeper quorum to use, when running Flink in a high-availability mode with ZooKeeper.");
    public static final ConfigOption<String> HA_ZOOKEEPER_ROOT = ConfigOptions.key("high-availability.zookeeper.path.root").defaultValue("/flink").withDeprecatedKeys("recovery.zookeeper.path.root").withDescription("The root path under which Flink stores its entries in ZooKeeper.");
    public static final ConfigOption<String> HA_ZOOKEEPER_LATCH_PATH = ConfigOptions.key("high-availability.zookeeper.path.latch").defaultValue("/leaderlatch").withDeprecatedKeys("recovery.zookeeper.path.latch").withDescription("Defines the znode of the leader latch which is used to elect the leader.");
    public static final ConfigOption<String> HA_ZOOKEEPER_JOBGRAPHS_PATH = ConfigOptions.key("high-availability.zookeeper.path.jobgraphs").defaultValue("/jobgraphs").withDeprecatedKeys("recovery.zookeeper.path.jobgraphs").withDescription("ZooKeeper root path (ZNode) for job graphs");
    public static final ConfigOption<String> HA_ZOOKEEPER_LEADER_PATH = ConfigOptions.key("high-availability.zookeeper.path.leader").defaultValue("/leader").withDeprecatedKeys("recovery.zookeeper.path.leader").withDescription("Defines the znode of the leader which contains the URL to the leader and the current leader session ID.");
    public static final ConfigOption<String> HA_ZOOKEEPER_CHECKPOINTS_PATH = ConfigOptions.key("high-availability.zookeeper.path.checkpoints").defaultValue("/checkpoints").withDeprecatedKeys("recovery.zookeeper.path.checkpoints").withDescription("ZooKeeper root path (ZNode) for completed checkpoints.");
    public static final ConfigOption<String> HA_ZOOKEEPER_CHECKPOINT_COUNTER_PATH = ConfigOptions.key("high-availability.zookeeper.path.checkpoint-counter").defaultValue("/checkpoint-counter").withDeprecatedKeys("recovery.zookeeper.path.checkpoint-counter").withDescription("ZooKeeper root path (ZNode) for checkpoint counters.");
    @PublicEvolving
    public static final ConfigOption<String> HA_ZOOKEEPER_MESOS_WORKERS_PATH = ConfigOptions.key("high-availability.zookeeper.path.mesos-workers").defaultValue("/mesos-workers").withDeprecatedKeys("recovery.zookeeper.path.mesos-workers").withDescription(Description.builder().text("The ZooKeeper root path for persisting the Mesos worker information.").build());
    public static final ConfigOption<Integer> ZOOKEEPER_SESSION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.session-timeout").defaultValue(60000).withDeprecatedKeys("recovery.zookeeper.client.session-timeout").withDescription("Defines the session timeout for the ZooKeeper session in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_CONNECTION_TIMEOUT = ConfigOptions.key("high-availability.zookeeper.client.connection-timeout").defaultValue(15000).withDeprecatedKeys("recovery.zookeeper.client.connection-timeout").withDescription("Defines the connection timeout for ZooKeeper in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_RETRY_WAIT = ConfigOptions.key("high-availability.zookeeper.client.retry-wait").defaultValue(5000).withDeprecatedKeys("recovery.zookeeper.client.retry-wait").withDescription("Defines the pause between consecutive retries in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_MAX_RETRY_ATTEMPTS = ConfigOptions.key("high-availability.zookeeper.client.max-retry-attempts").defaultValue(3).withDeprecatedKeys("recovery.zookeeper.client.max-retry-attempts").withDescription("Defines the number of connection retries before the client gives up.");
    public static final ConfigOption<String> ZOOKEEPER_RUNNING_JOB_REGISTRY_PATH = ConfigOptions.key("high-availability.zookeeper.path.running-registry").defaultValue("/running_job_registry/");
    public static final ConfigOption<String> ZOOKEEPER_CLIENT_ACL = ConfigOptions.key("high-availability.zookeeper.client.acl").defaultValue("open").withDescription("Defines the ACL (open|creator) to be configured on ZK node. The configuration value can be set to \u201ccreator\u201d if the ZooKeeper server configuration has the \u201cauthProvider\u201d property mapped to use SASLAuthenticationProvider and the cluster is configured to run in secure mode (Kerberos).");

    private HighAvailabilityOptions() {
    }
}

