/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class SimpleTypeSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final int CURRENT_VERSION = 2;
    @Nullable
    private Class<? extends TypeSerializer<T>> serializerClass;

    public SimpleTypeSerializerSnapshot() {
    }

    public SimpleTypeSerializerSnapshot(@Nonnull Class<? extends TypeSerializer<T>> serializerClass) {
        this.serializerClass = Preconditions.checkNotNull(serializerClass);
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        Preconditions.checkState(this.serializerClass != null);
        return InstantiationUtil.instantiate(this.serializerClass);
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
        Preconditions.checkState(this.serializerClass != null);
        return newSerializer.getClass() == this.serializerClass ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.incompatible();
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
        Preconditions.checkState(this.serializerClass != null);
        out.writeUTF(this.serializerClass.getName());
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader) throws IOException {
        switch (readVersion) {
            case 2: {
                this.read(in, classLoader);
                break;
            }
            default: {
                throw new IOException("Unrecognized version: " + readVersion);
            }
        }
    }

    private void read(DataInputView in, ClassLoader classLoader) throws IOException {
        String className = in.readUTF();
        Class<?> clazz = SimpleTypeSerializerSnapshot.resolveClassName(className, classLoader, false);
        this.serializerClass = SimpleTypeSerializerSnapshot.cast(clazz);
    }

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static Class<?> resolveClassName(String className, ClassLoader cl, boolean allowCanonicalName) throws IOException {
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            if (allowCanonicalName) {
                try {
                    return Class.forName(SimpleTypeSerializerSnapshot.guessClassNameFromCanonical(className), false, cl);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new IOException("Failed to read SimpleTypeSerializerSnapshot: Serializer class not found: " + className, e);
        }
    }

    private static <T> Class<? extends TypeSerializer<T>> cast(Class<?> clazz) throws IOException {
        if (!TypeSerializer.class.isAssignableFrom(clazz)) {
            throw new IOException("Failed to read SimpleTypeSerializerSnapshot. Serializer class name leads to a class that is not a TypeSerializer: " + clazz.getName());
        }
        return clazz;
    }

    static String guessClassNameFromCanonical(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0 && lastDot < className.length() - 1) {
            return className.substring(0, lastDot) + '$' + className.substring(lastDot + 1);
        }
        return className;
    }
}

