/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class DoublePrimitiveArraySerializer
extends TypeSerializerSingleton<double[]> {
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY = new double[0];
    public static final DoublePrimitiveArraySerializer INSTANCE = new DoublePrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public double[] createInstance() {
        return EMPTY;
    }

    @Override
    public double[] copy(double[] from) {
        double[] copy = new double[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    @Override
    public double[] copy(double[] from, double[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(double[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeDouble(record[i]);
        }
    }

    @Override
    public double[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = source.readDouble();
        }
        return result;
    }

    @Override
    public double[] deserialize(double[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len * 8);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof DoublePrimitiveArraySerializer;
    }

    @Override
    public TypeSerializerSnapshot<double[]> snapshotConfiguration() {
        return new DoublePrimitiveArraySerializerSnapshot();
    }

    public static final class DoublePrimitiveArraySerializerSnapshot
    extends SimpleTypeSerializerSnapshot<double[]> {
        public DoublePrimitiveArraySerializerSnapshot() {
            super(DoublePrimitiveArraySerializer.class);
        }
    }
}

