/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public final class CopyableValueSerializer<T extends CopyableValue<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> valueClass;
    private transient T instance;

    public CopyableValueSerializer(Class<T> valueClass) {
        this.valueClass = Preconditions.checkNotNull(valueClass);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public CopyableValueSerializer<T> duplicate() {
        return this;
    }

    @Override
    public T createInstance() {
        return (T)((CopyableValue)InstantiationUtil.instantiate(this.valueClass));
    }

    @Override
    public T copy(T from) {
        return (T)this.copy(from, (T)this.createInstance());
    }

    @Override
    public T copy(T from, T reuse) {
        from.copyTo(reuse);
        return reuse;
    }

    @Override
    public int getLength() {
        this.ensureInstanceInstantiated();
        return this.instance.getBinaryLength();
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return (T)this.deserialize((T)this.createInstance(), source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.ensureInstanceInstantiated();
        this.instance.copy(source, target);
    }

    private void ensureInstanceInstantiated() {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
    }

    @Override
    public int hashCode() {
        return this.valueClass.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CopyableValueSerializer) {
            CopyableValueSerializer copyableValueSerializer = (CopyableValueSerializer)obj;
            return copyableValueSerializer.canEqual(this) && this.valueClass == copyableValueSerializer.valueClass;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof CopyableValueSerializer;
    }

    @Override
    public CopyableValueSerializerConfigSnapshot<T> snapshotConfiguration() {
        return new CopyableValueSerializerConfigSnapshot<T>(this.valueClass);
    }

    @Override
    public CompatibilityResult<T> ensureCompatibility(TypeSerializerConfigSnapshot<?> configSnapshot) {
        if (configSnapshot instanceof CopyableValueSerializerConfigSnapshot && this.valueClass.equals(((CopyableValueSerializerConfigSnapshot)configSnapshot).getTypeClass())) {
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    public static final class CopyableValueSerializerConfigSnapshot<T extends CopyableValue<T>>
    extends GenericTypeSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;

        public CopyableValueSerializerConfigSnapshot() {
        }

        public CopyableValueSerializerConfigSnapshot(Class<T> copyableValueClass) {
            super(copyableValueClass);
        }

        @Override
        public int getVersion() {
            return 1;
        }
    }
}

