/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.flink.annotation.Internal;

@Internal
public class FutureUtil {
    private FutureUtil() {
        throw new AssertionError();
    }

    public static <T> T runIfNotDoneAndGet(RunnableFuture<T> future) throws ExecutionException, InterruptedException {
        if (null == future) {
            return null;
        }
        if (!future.isDone()) {
            future.run();
        }
        return (T)future.get();
    }

    public static void waitForAll(long timeoutMillis, Future<?> ... futures) throws Exception {
        FutureUtil.waitForAll(timeoutMillis, Arrays.asList(futures));
    }

    public static void waitForAll(long timeoutMillis, Collection<Future<?>> futures) throws Exception {
        long startMillis = System.currentTimeMillis();
        HashSet futuresSet = new HashSet();
        futuresSet.addAll(futures);
        while (System.currentTimeMillis() < startMillis + timeoutMillis) {
            if (futuresSet.isEmpty()) {
                return;
            }
            Iterator futureIterator = futuresSet.iterator();
            while (futureIterator.hasNext()) {
                Future future = (Future)futureIterator.next();
                if (!future.isDone()) continue;
                future.get();
                futureIterator.remove();
            }
            Thread.sleep(10L);
        }
        if (!futuresSet.isEmpty()) {
            throw new TimeoutException(String.format("Some of the futures have not finished [%s]", futuresSet));
        }
    }
}

