/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.resources.GPUResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.util.Preconditions;

@Internal
public final class ResourceSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ResourceSpec UNKNOWN;
    public static final ResourceSpec DEFAULT;
    public static final String GPU_NAME = "GPU";
    private final double cpuCores;
    private final int heapMemoryInMB;
    private final int directMemoryInMB;
    private final int nativeMemoryInMB;
    private final int stateSizeInMB;
    private final int managedMemoryInMB;
    private final Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);

    private ResourceSpec(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int stateSizeInMB, int managedMemoryInMB, Resource ... extendedResources) {
        Preconditions.checkArgument(cpuCores >= 0.0, "The cpu cores of the resource spec should not be negative.");
        Preconditions.checkArgument(heapMemoryInMB >= 0, "The heap memory of the resource spec should not be negative");
        Preconditions.checkArgument(directMemoryInMB >= 0, "The direct memory of the resource spec should not be negative");
        Preconditions.checkArgument(nativeMemoryInMB >= 0, "The native memory of the resource spec should not be negative");
        Preconditions.checkArgument(stateSizeInMB >= 0, "The state size of the resource spec should not be negative");
        Preconditions.checkArgument(managedMemoryInMB >= 0, "The managed memory of the resource spec should not be negative");
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.stateSizeInMB = stateSizeInMB;
        this.managedMemoryInMB = managedMemoryInMB;
        for (Resource resource : extendedResources) {
            if (resource == null) continue;
            this.extendedResources.put(resource.getName(), resource);
        }
    }

    private ResourceSpec() {
        this.cpuCores = -1.0;
        this.heapMemoryInMB = -1;
        this.directMemoryInMB = -1;
        this.nativeMemoryInMB = -1;
        this.stateSizeInMB = -1;
        this.managedMemoryInMB = -1;
    }

    public ResourceSpec merge(ResourceSpec other) {
        if (this.equals(UNKNOWN) || other.equals(UNKNOWN)) {
            return UNKNOWN;
        }
        ResourceSpec target = new ResourceSpec(Math.max(this.cpuCores, other.cpuCores), this.heapMemoryInMB + other.heapMemoryInMB, this.directMemoryInMB + other.directMemoryInMB, this.nativeMemoryInMB + other.nativeMemoryInMB, this.stateSizeInMB + other.stateSizeInMB, this.managedMemoryInMB + other.managedMemoryInMB, new Resource[0]);
        target.extendedResources.putAll(this.extendedResources);
        for (Resource resource : other.extendedResources.values()) {
            target.extendedResources.merge(resource.getName(), resource, (v1, v2) -> v1.merge((Resource)v2));
        }
        return target;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public int getHeapMemory() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemory() {
        return this.directMemoryInMB;
    }

    public int getNativeMemory() {
        return this.nativeMemoryInMB;
    }

    public int getStateSize() {
        return this.stateSizeInMB;
    }

    public int getManagedMemory() {
        return this.managedMemoryInMB;
    }

    public double getGPUResource() {
        Resource gpuResource = this.extendedResources.get(GPU_NAME);
        if (gpuResource != null) {
            return gpuResource.getValue();
        }
        return 0.0;
    }

    public Map<String, Resource> getExtendedResources() {
        return this.extendedResources;
    }

    public boolean isValid() {
        if (this.cpuCores >= 0.0 && this.heapMemoryInMB >= 0 && this.directMemoryInMB >= 0 && this.nativeMemoryInMB >= 0 && this.stateSizeInMB >= 0 && this.managedMemoryInMB >= 0) {
            for (Resource resource : this.extendedResources.values()) {
                if (!(resource.getValue() < 0.0)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean lessThanOrEqual(@Nonnull ResourceSpec other) {
        int cmp1 = Double.compare(this.cpuCores, other.cpuCores);
        int cmp2 = Integer.compare(this.heapMemoryInMB, other.heapMemoryInMB);
        int cmp3 = Integer.compare(this.directMemoryInMB, other.directMemoryInMB);
        int cmp4 = Integer.compare(this.nativeMemoryInMB, other.nativeMemoryInMB);
        int cmp5 = Integer.compare(this.stateSizeInMB, other.stateSizeInMB);
        int cmp6 = Integer.compare(this.managedMemoryInMB, other.managedMemoryInMB);
        if (cmp1 <= 0 && cmp2 <= 0 && cmp3 <= 0 && cmp4 <= 0 && cmp5 <= 0 && cmp6 <= 0) {
            for (Resource resource : this.extendedResources.values()) {
                if (other.extendedResources.containsKey(resource.getName()) && other.extendedResources.get(resource.getName()).getResourceAggregateType() == resource.getResourceAggregateType() && !(other.extendedResources.get(resource.getName()).getValue() < resource.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceSpec.class) {
            ResourceSpec that = (ResourceSpec)obj;
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.nativeMemoryInMB == that.nativeMemoryInMB && this.stateSizeInMB == that.stateSizeInMB && this.managedMemoryInMB == that.managedMemoryInMB && Objects.equals(this.extendedResources, that.extendedResources);
        }
        return false;
    }

    public int hashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        result = 31 * result + this.stateSizeInMB;
        result = 31 * result + this.managedMemoryInMB;
        result = 31 * result + this.extendedResources.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder extend = new StringBuilder();
        for (Resource resource : this.extendedResources.values()) {
            extend.append(", ").append(resource.getName()).append("=").append(resource.getValue());
        }
        return "ResourceSpec{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + ", stateSizeInMB=" + this.stateSizeInMB + ", managedMemoryInMB=" + this.managedMemoryInMB + extend + '}';
    }

    private Object readResolve() {
        return this.equals(UNKNOWN) ? UNKNOWN : this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        DEFAULT = UNKNOWN = new ResourceSpec();
    }

    public static class Builder {
        private double cpuCores;
        private int heapMemoryInMB;
        private int directMemoryInMB;
        private int nativeMemoryInMB;
        private int stateSizeInMB;
        private int managedMemoryInMB;
        private GPUResource gpuResource;

        public Builder setCpuCores(double cpuCores) {
            this.cpuCores = cpuCores;
            return this;
        }

        public Builder setHeapMemoryInMB(int heapMemory) {
            this.heapMemoryInMB = heapMemory;
            return this;
        }

        public Builder setDirectMemoryInMB(int directMemory) {
            this.directMemoryInMB = directMemory;
            return this;
        }

        public Builder setNativeMemoryInMB(int nativeMemory) {
            this.nativeMemoryInMB = nativeMemory;
            return this;
        }

        public Builder setStateSizeInMB(int stateSize) {
            this.stateSizeInMB = stateSize;
            return this;
        }

        public Builder setManagedMemoryInMB(int managedMemory) {
            this.managedMemoryInMB = managedMemory;
            return this;
        }

        public Builder setGPUResource(double gpus) {
            this.gpuResource = new GPUResource(gpus);
            return this;
        }

        public ResourceSpec build() {
            return new ResourceSpec(this.cpuCores, this.heapMemoryInMB, this.directMemoryInMB, this.nativeMemoryInMB, this.stateSizeInMB, this.managedMemoryInMB, new Resource[]{this.gpuResource});
        }
    }
}

