/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.resources;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class Resource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final double value;
    private final ResourceAggregateType resourceAggregateType;

    protected Resource(String name, double value, ResourceAggregateType type) {
        this.name = Preconditions.checkNotNull(name);
        this.value = value;
        this.resourceAggregateType = Preconditions.checkNotNull(type);
    }

    public Resource merge(Resource other) {
        double aggregatedValue;
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Merge with different resource type");
        Preconditions.checkArgument(this.name.equals(other.name), "Merge with different resource name");
        Preconditions.checkArgument(this.resourceAggregateType == other.resourceAggregateType, "Merge with different aggregate resourceAggregateType");
        switch (this.resourceAggregateType) {
            case AGGREGATE_TYPE_MAX: {
                aggregatedValue = Math.max(this.value, other.value);
                break;
            }
            default: {
                aggregatedValue = this.value + other.value;
            }
        }
        return this.create(aggregatedValue, this.resourceAggregateType);
    }

    public Resource subtract(Resource other) {
        double subtractedValue;
        Preconditions.checkArgument(this.getClass() == other.getClass(), "Minus with different resource type");
        Preconditions.checkArgument(this.name.equals(other.name), "Minus with different resource name");
        Preconditions.checkArgument(this.resourceAggregateType == other.resourceAggregateType, "Minus with different aggregate resourceAggregateType");
        Preconditions.checkArgument(this.value >= other.value, "Try to subtract a larger resource from this one.");
        switch (this.resourceAggregateType) {
            case AGGREGATE_TYPE_MAX: {
                subtractedValue = this.value;
                break;
            }
            default: {
                subtractedValue = this.value - other.value;
            }
        }
        return this.create(subtractedValue, this.resourceAggregateType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Resource other = (Resource)o;
            return this.name.equals(other.name) && this.resourceAggregateType == other.resourceAggregateType && this.value == other.value;
        }
        return false;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.resourceAggregateType.ordinal();
        result = 31 * result + (int)this.value;
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ResourceAggregateType getResourceAggregateType() {
        return this.resourceAggregateType;
    }

    public double getValue() {
        return this.value;
    }

    protected abstract Resource create(double var1, ResourceAggregateType var3);

    public static enum ResourceAggregateType {
        AGGREGATE_TYPE_SUM,
        AGGREGATE_TYPE_MAX;

    }
}

