/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import java.util.EnumMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StateTtlConfig
implements Serializable {
    private static final long serialVersionUID = -7592693245044289793L;
    public static final StateTtlConfig DISABLED = StateTtlConfig.newBuilder(Time.milliseconds(Long.MAX_VALUE)).setUpdateType(UpdateType.Disabled).build();
    private final UpdateType updateType;
    private final StateVisibility stateVisibility;
    private final TtlTimeCharacteristic ttlTimeCharacteristic;
    private final Time ttl;
    private final CleanupStrategies cleanupStrategies;

    private StateTtlConfig(UpdateType updateType, StateVisibility stateVisibility, TtlTimeCharacteristic ttlTimeCharacteristic, Time ttl, CleanupStrategies cleanupStrategies) {
        this.updateType = Preconditions.checkNotNull(updateType);
        this.stateVisibility = Preconditions.checkNotNull(stateVisibility);
        this.ttlTimeCharacteristic = Preconditions.checkNotNull(ttlTimeCharacteristic);
        this.ttl = Preconditions.checkNotNull(ttl);
        this.cleanupStrategies = cleanupStrategies;
        Preconditions.checkArgument(ttl.toMilliseconds() > 0L, "TTL is expected to be positive.");
    }

    @Nonnull
    public UpdateType getUpdateType() {
        return this.updateType;
    }

    @Nonnull
    public StateVisibility getStateVisibility() {
        return this.stateVisibility;
    }

    @Nonnull
    public Time getTtl() {
        return this.ttl;
    }

    @Nonnull
    public TtlTimeCharacteristic getTtlTimeCharacteristic() {
        return this.ttlTimeCharacteristic;
    }

    public boolean isEnabled() {
        return this.updateType != UpdateType.Disabled;
    }

    @Nonnull
    public CleanupStrategies getCleanupStrategies() {
        return this.cleanupStrategies;
    }

    public String toString() {
        return "StateTtlConfig{updateType=" + (Object)((Object)this.updateType) + ", stateVisibility=" + (Object)((Object)this.stateVisibility) + ", ttlTimeCharacteristic=" + (Object)((Object)this.ttlTimeCharacteristic) + ", ttl=" + this.ttl + '}';
    }

    @Nonnull
    public static Builder newBuilder(@Nonnull Time ttl) {
        return new Builder(ttl);
    }

    public static class RocksdbCompactFilterCleanupStrategy
    implements CleanupStrategies.CleanupStrategy {
        private static final long serialVersionUID = 3109278796506988980L;
        static final RocksdbCompactFilterCleanupStrategy DEFAULT_ROCKSDB_COMPACT_FILTER_CLEANUP_STRATEGY = new RocksdbCompactFilterCleanupStrategy(1000L);
        private final long queryTimeAfterNumEntries;

        private RocksdbCompactFilterCleanupStrategy(long queryTimeAfterNumEntries) {
            this.queryTimeAfterNumEntries = queryTimeAfterNumEntries;
        }

        public long getQueryTimeAfterNumEntries() {
            return this.queryTimeAfterNumEntries;
        }
    }

    public static class IncrementalCleanupStrategy
    implements CleanupStrategies.CleanupStrategy {
        private static final long serialVersionUID = 3109278696501988780L;
        static final IncrementalCleanupStrategy DEFAULT_INCREMENTAL_CLEANUP_STRATEGY = new IncrementalCleanupStrategy(5, false);
        private final int cleanupSize;
        private final boolean runCleanupForEveryRecord;

        private IncrementalCleanupStrategy(int cleanupSize, boolean runCleanupForEveryRecord) {
            Preconditions.checkArgument(cleanupSize >= 0, "Number of incrementally cleaned up state entries cannot be negative.");
            this.cleanupSize = cleanupSize;
            this.runCleanupForEveryRecord = runCleanupForEveryRecord;
        }

        public int getCleanupSize() {
            return this.cleanupSize;
        }

        public boolean runCleanupForEveryRecord() {
            return this.runCleanupForEveryRecord;
        }
    }

    public static class CleanupStrategies
    implements Serializable {
        private static final long serialVersionUID = -1617740467277313524L;
        static final CleanupStrategy EMPTY_STRATEGY = new EmptyCleanupStrategy();
        private final boolean isCleanupInBackground;
        private final EnumMap<Strategies, CleanupStrategy> strategies;

        private CleanupStrategies(EnumMap<Strategies, CleanupStrategy> strategies, boolean isCleanupInBackground) {
            this.strategies = strategies;
            this.isCleanupInBackground = isCleanupInBackground;
        }

        public boolean inFullSnapshot() {
            return this.strategies.containsKey((Object)Strategies.FULL_STATE_SCAN_SNAPSHOT);
        }

        public boolean isCleanupInBackground() {
            return this.isCleanupInBackground;
        }

        @Nullable
        public IncrementalCleanupStrategy getIncrementalCleanupStrategy() {
            IncrementalCleanupStrategy defaultStrategy = this.isCleanupInBackground ? IncrementalCleanupStrategy.DEFAULT_INCREMENTAL_CLEANUP_STRATEGY : null;
            return (IncrementalCleanupStrategy)this.strategies.getOrDefault((Object)Strategies.INCREMENTAL_CLEANUP, defaultStrategy);
        }

        public boolean inRocksdbCompactFilter() {
            return this.getRocksdbCompactFilterCleanupStrategy() != null;
        }

        @Nullable
        public RocksdbCompactFilterCleanupStrategy getRocksdbCompactFilterCleanupStrategy() {
            RocksdbCompactFilterCleanupStrategy defaultStrategy = this.isCleanupInBackground ? RocksdbCompactFilterCleanupStrategy.DEFAULT_ROCKSDB_COMPACT_FILTER_CLEANUP_STRATEGY : null;
            return (RocksdbCompactFilterCleanupStrategy)this.strategies.getOrDefault((Object)Strategies.ROCKSDB_COMPACTION_FILTER, defaultStrategy);
        }

        static class EmptyCleanupStrategy
        implements CleanupStrategy {
            private static final long serialVersionUID = 1373998465131443873L;

            EmptyCleanupStrategy() {
            }
        }

        static interface CleanupStrategy
        extends Serializable {
        }

        static enum Strategies {
            FULL_STATE_SCAN_SNAPSHOT,
            INCREMENTAL_CLEANUP,
            ROCKSDB_COMPACTION_FILTER;

        }
    }

    public static class Builder {
        private UpdateType updateType = UpdateType.OnCreateAndWrite;
        private StateVisibility stateVisibility = StateVisibility.NeverReturnExpired;
        private TtlTimeCharacteristic ttlTimeCharacteristic = TtlTimeCharacteristic.ProcessingTime;
        private Time ttl;
        private boolean isCleanupInBackground = false;
        private final EnumMap<CleanupStrategies.Strategies, CleanupStrategies.CleanupStrategy> strategies = new EnumMap(CleanupStrategies.Strategies.class);

        public Builder(@Nonnull Time ttl) {
            this.ttl = ttl;
        }

        @Nonnull
        public Builder setUpdateType(UpdateType updateType) {
            this.updateType = updateType;
            return this;
        }

        @Nonnull
        public Builder updateTtlOnCreateAndWrite() {
            return this.setUpdateType(UpdateType.OnCreateAndWrite);
        }

        @Nonnull
        public Builder updateTtlOnReadAndWrite() {
            return this.setUpdateType(UpdateType.OnReadAndWrite);
        }

        @Nonnull
        public Builder setStateVisibility(@Nonnull StateVisibility stateVisibility) {
            this.stateVisibility = stateVisibility;
            return this;
        }

        @Nonnull
        public Builder returnExpiredIfNotCleanedUp() {
            return this.setStateVisibility(StateVisibility.ReturnExpiredIfNotCleanedUp);
        }

        @Nonnull
        public Builder neverReturnExpired() {
            return this.setStateVisibility(StateVisibility.NeverReturnExpired);
        }

        @Deprecated
        @Nonnull
        public Builder setTimeCharacteristic(@Nonnull TimeCharacteristic timeCharacteristic) {
            Preconditions.checkArgument(timeCharacteristic.equals((Object)TimeCharacteristic.ProcessingTime), "Only support TimeCharacteristic.ProcessingTime, this function has replaced by setTtlTimeCharacteristic.");
            this.setTtlTimeCharacteristic(TtlTimeCharacteristic.ProcessingTime);
            return this;
        }

        @Nonnull
        public Builder setTtlTimeCharacteristic(@Nonnull TtlTimeCharacteristic ttlTimeCharacteristic) {
            this.ttlTimeCharacteristic = ttlTimeCharacteristic;
            return this;
        }

        @Nonnull
        public Builder useProcessingTime() {
            return this.setTtlTimeCharacteristic(TtlTimeCharacteristic.ProcessingTime);
        }

        @Nonnull
        public Builder cleanupFullSnapshot() {
            this.strategies.put(CleanupStrategies.Strategies.FULL_STATE_SCAN_SNAPSHOT, CleanupStrategies.EMPTY_STRATEGY);
            return this;
        }

        @Nonnull
        public Builder cleanupIncrementally(@Nonnegative int cleanupSize, boolean runCleanupForEveryRecord) {
            this.strategies.put(CleanupStrategies.Strategies.INCREMENTAL_CLEANUP, new IncrementalCleanupStrategy(cleanupSize, runCleanupForEveryRecord));
            return this;
        }

        @Nonnull
        @Deprecated
        public Builder cleanupInRocksdbCompactFilter() {
            return this.cleanupInRocksdbCompactFilter(1000L);
        }

        @Nonnull
        public Builder cleanupInRocksdbCompactFilter(long queryTimeAfterNumEntries) {
            this.strategies.put(CleanupStrategies.Strategies.ROCKSDB_COMPACTION_FILTER, new RocksdbCompactFilterCleanupStrategy(queryTimeAfterNumEntries));
            return this;
        }

        @Nonnull
        public Builder cleanupInBackground() {
            this.isCleanupInBackground = true;
            return this;
        }

        @Nonnull
        public Builder setTtl(@Nonnull Time ttl) {
            this.ttl = ttl;
            return this;
        }

        @Nonnull
        public StateTtlConfig build() {
            return new StateTtlConfig(this.updateType, this.stateVisibility, this.ttlTimeCharacteristic, this.ttl, new CleanupStrategies(this.strategies, this.isCleanupInBackground));
        }
    }

    public static enum TtlTimeCharacteristic {
        ProcessingTime;

    }

    @Deprecated
    public static enum TimeCharacteristic {
        ProcessingTime;

    }

    public static enum StateVisibility {
        ReturnExpiredIfNotCleanedUp,
        NeverReturnExpired;

    }

    public static enum UpdateType {
        Disabled,
        OnCreateAndWrite,
        OnReadAndWrite;

    }
}

