/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerBase;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerConfigSnapshot;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.NullFieldException;
import org.apache.flink.util.Preconditions;

@Internal
public class TupleSerializer<T extends Tuple>
extends TupleSerializerBase<T>
implements TypeSerializerConfigSnapshot.SelfResolvingTypeSerializer<T> {
    private static final long serialVersionUID = 1L;

    public TupleSerializer(Class<T> tupleClass, TypeSerializer<?>[] fieldSerializers) {
        super(tupleClass, fieldSerializers);
    }

    @Override
    public TupleSerializer<T> duplicate() {
        boolean stateful = false;
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
            if (duplicateFieldSerializers[i] == this.fieldSerializers[i]) continue;
            stateful = true;
        }
        if (stateful) {
            return new TupleSerializer<T>(this.tupleClass, duplicateFieldSerializers);
        }
        return this;
    }

    @Override
    public T createInstance() {
        try {
            Tuple t = (Tuple)this.tupleClass.newInstance();
            for (int i = 0; i < this.arity; ++i) {
                t.setField(this.fieldSerializers[i].createInstance(), i);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    @Override
    public T createInstance(Object[] fields) {
        try {
            Tuple t = (Tuple)this.tupleClass.newInstance();
            for (int i = 0; i < this.arity; ++i) {
                t.setField(fields[i], i);
            }
            return (T)t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    @Override
    public T createOrReuseInstance(Object[] fields, T reuse) {
        for (int i = 0; i < this.arity; ++i) {
            ((Tuple)reuse).setField((Object)fields[i], i);
        }
        return (T)reuse;
    }

    @Override
    public T copy(T from) {
        Object target = this.instantiateRaw();
        for (int i = 0; i < this.arity; ++i) {
            Object copy = this.fieldSerializers[i].copy(((Tuple)from).getField(i));
            ((Tuple)target).setField(copy, i);
        }
        return target;
    }

    @Override
    public T copy(T from, T reuse) {
        for (int i = 0; i < this.arity; ++i) {
            Object copy = this.fieldSerializers[i].copy(((Tuple)from).getField(i), ((Tuple)reuse).getField(i));
            ((Tuple)reuse).setField(copy, i);
        }
        return reuse;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object o = ((Tuple)value).getField(i);
            try {
                this.fieldSerializers[i].serialize(o, target);
                continue;
            }
            catch (NullPointerException npex) {
                throw new NullFieldException(i, (Throwable)npex);
            }
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        Object tuple = this.instantiateRaw();
        for (int i = 0; i < this.arity; ++i) {
            Object field = this.fieldSerializers[i].deserialize(source);
            ((Tuple)tuple).setField(field, i);
        }
        return tuple;
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        for (int i = 0; i < this.arity; ++i) {
            Object field = this.fieldSerializers[i].deserialize(((Tuple)reuse).getField(i), source);
            ((Tuple)reuse).setField(field, i);
        }
        return reuse;
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new TupleSerializerSnapshot(this);
    }

    private T instantiateRaw() {
        try {
            return (T)((Tuple)this.tupleClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate tuple.", e);
        }
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibilityViaRedirectingToNewSnapshotClass(TypeSerializerConfigSnapshot<T> deprecatedConfigSnapshot) {
        Preconditions.checkArgument(deprecatedConfigSnapshot instanceof TupleSerializerConfigSnapshot);
        TupleSerializerConfigSnapshot configSnapshot = (TupleSerializerConfigSnapshot)deprecatedConfigSnapshot;
        TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])configSnapshot.getNestedSerializersAndConfigs().stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
        TupleSerializerSnapshot newCompositeSnapshot = new TupleSerializerSnapshot(configSnapshot.getTupleClass());
        return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(this, newCompositeSnapshot, nestedSnapshots);
    }
}

