/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ClusterOptions {
    public static final ConfigOption<Long> INITIAL_REGISTRATION_TIMEOUT = ConfigOptions.key("cluster.registration.initial-timeout").defaultValue(100L).withDescription("Initial registration timeout between cluster components in milliseconds.");
    public static final ConfigOption<Long> MAX_REGISTRATION_TIMEOUT = ConfigOptions.key("cluster.registration.max-timeout").defaultValue(30000L).withDescription("Maximum registration timeout between cluster components in milliseconds.");
    public static final ConfigOption<Long> ERROR_REGISTRATION_DELAY = ConfigOptions.key("cluster.registration.error-delay").defaultValue(10000L).withDescription("The pause made after an registration attempt caused an exception (other than timeout) in milliseconds.");
    public static final ConfigOption<Long> REFUSED_REGISTRATION_DELAY = ConfigOptions.key("cluster.registration.refused-registration-delay").defaultValue(30000L).withDescription("The pause made after the registration attempt was refused in milliseconds.");
    public static final ConfigOption<Long> CLUSTER_SERVICES_SHUTDOWN_TIMEOUT = ConfigOptions.key("cluster.services.shutdown-timeout").defaultValue(30000L).withDescription("The shutdown timeout for cluster services like executors in milliseconds.");
    public static final ConfigOption<Boolean> EVENLY_SPREAD_OUT_SLOTS_STRATEGY = ConfigOptions.key("cluster.evenly-spread-out-slots").defaultValue(false).withDescription(Description.builder().text("Enable the slot spread out allocation strategy. This strategy tries to spread out the slots evenly across all available %s.", TextElement.code("TaskExecutors")).build());
}

