/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ConfigOptions {
    public static OptionBuilder key(String key) {
        Preconditions.checkNotNull(key);
        return new OptionBuilder(key);
    }

    private ConfigOptions() {
    }

    public static final class OptionBuilder {
        private final String key;

        OptionBuilder(String key) {
            this.key = key;
        }

        public <T> ConfigOption<T> defaultValue(T value) {
            Preconditions.checkNotNull(value);
            return new ConfigOption<T>(this.key, value);
        }

        public ConfigOption<String> noDefaultValue() {
            return new ConfigOption<Object>(this.key, null);
        }
    }
}

