/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class Configuration
extends ExecutionConfig.GlobalJobParameters
implements IOReadableWritable,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final byte TYPE_STRING = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_BOOLEAN = 3;
    private static final byte TYPE_FLOAT = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_BYTES = 6;
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    protected final HashMap<String, Object> confData;

    public Configuration() {
        this.confData = new HashMap();
    }

    public Configuration(Configuration other) {
        this.confData = new HashMap<String, Object>(other.confData);
    }

    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        if (o.getClass() == String.class) {
            return Class.forName((String)o, true, classLoader);
        }
        LOG.warn("Configuration cannot evaluate value " + o + " as a class name");
        return defaultValue;
    }

    public void setClass(String key, Class<?> klazz) {
        this.setValueInternal(key, klazz.getName());
    }

    public String getString(String key, String defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return o.toString();
    }

    @PublicEvolving
    public String getString(ConfigOption<String> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return o == null ? null : o.toString();
    }

    @PublicEvolving
    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        return o == null ? overrideDefault : o.toString();
    }

    public void setString(String key, String value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setString(ConfigOption<String> key, String value) {
        this.setValueInternal(key.key(), value);
    }

    public int getInteger(String key, int defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return this.convertToInt(o, defaultValue);
    }

    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return this.convertToInt(o, configOption.defaultValue());
    }

    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        if (o == null) {
            return overrideDefault;
        }
        return this.convertToInt(o, configOption.defaultValue());
    }

    public void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setInteger(ConfigOption<Integer> key, int value) {
        this.setValueInternal(key.key(), value);
    }

    public long getLong(String key, long defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return this.convertToLong(o, defaultValue);
    }

    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return this.convertToLong(o, configOption.defaultValue());
    }

    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        if (o == null) {
            return overrideDefault;
        }
        return this.convertToLong(o, configOption.defaultValue());
    }

    public void setLong(String key, long value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setLong(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return this.convertToBoolean(o);
    }

    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return this.convertToBoolean(o);
    }

    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        if (o == null) {
            return overrideDefault;
        }
        return this.convertToBoolean(o);
    }

    public void setBoolean(String key, boolean value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        this.setValueInternal(key.key(), value);
    }

    public float getFloat(String key, float defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return this.convertToFloat(o, defaultValue);
    }

    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return this.convertToFloat(o, configOption.defaultValue().floatValue());
    }

    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        if (o == null) {
            return overrideDefault;
        }
        return this.convertToFloat(o, configOption.defaultValue().floatValue());
    }

    public void setFloat(String key, float value) {
        this.setValueInternal(key, Float.valueOf(value));
    }

    @PublicEvolving
    public void setFloat(ConfigOption<Float> key, float value) {
        this.setValueInternal(key.key(), Float.valueOf(value));
    }

    public double getDouble(String key, double defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        return this.convertToDouble(o, defaultValue);
    }

    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return this.convertToDouble(o, configOption.defaultValue());
    }

    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        Object o = this.getRawValueFromOption(configOption);
        if (o == null) {
            return overrideDefault;
        }
        return this.convertToDouble(o, configOption.defaultValue());
    }

    public void setDouble(String key, double value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setDouble(ConfigOption<Double> key, double value) {
        this.setValueInternal(key.key(), value);
    }

    public byte[] getBytes(String key, byte[] defaultValue) {
        Object o = this.getRawValue(key);
        if (o == null) {
            return defaultValue;
        }
        if (o.getClass().equals(byte[].class)) {
            return (byte[])o;
        }
        LOG.warn("Configuration cannot evaluate value {} as a byte[] value", o);
        return defaultValue;
    }

    public void setBytes(String key, byte[] bytes) {
        this.setValueInternal(key, bytes);
    }

    @PublicEvolving
    public String getValue(ConfigOption<?> configOption) {
        Object o = this.getValueOrDefaultFromOption(configOption);
        return o == null ? null : o.toString();
    }

    @PublicEvolving
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        Preconditions.checkNotNull(enumClass, "enumClass must not be null");
        Preconditions.checkNotNull(configOption, "configOption must not be null");
        String configValue = this.getString(configOption);
        try {
            return Enum.valueOf(enumClass, configValue.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            String errorMessage = String.format("Value for config option %s must be one of %s (was %s)", configOption.key(), Arrays.toString(enumClass.getEnumConstants()), configValue);
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return new HashSet<String>(this.confData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                this.confData.putAll(other.confData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other, String prefix) {
        StringBuilder bld = new StringBuilder();
        bld.append(prefix);
        int pl = bld.length();
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                for (Map.Entry<String, Object> entry : other.confData.entrySet()) {
                    bld.setLength(pl);
                    bld.append(entry.getKey());
                    this.confData.put(bld.toString(), entry.getValue());
                }
            }
        }
    }

    public Configuration clone() {
        Configuration config = new Configuration();
        config.addAll(this);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicEvolving
    public boolean contains(ConfigOption<?> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            if (this.confData.containsKey(configOption.key())) {
                return true;
            }
            if (configOption.hasFallbackKeys()) {
                for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                    if (!this.confData.containsKey(fallbackKey.getKey())) continue;
                    this.loggingFallback(fallbackKey, configOption);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> toMap() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, String> ret = new HashMap<String, String>(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                ret.put(entry.getKey(), entry.getValue().toString());
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            Object oldValue = this.confData.remove(configOption.key());
            if (oldValue == null) {
                for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                    oldValue = this.confData.remove(fallbackKey.getKey());
                    if (oldValue == null) continue;
                    this.loggingFallback(fallbackKey, configOption);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setValueInternal(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            this.confData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getRawValue(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.get(key);
        }
    }

    private Object getRawValueFromOption(ConfigOption<?> configOption) {
        Object o = this.getRawValue(configOption.key());
        if (o != null) {
            return o;
        }
        if (configOption.hasFallbackKeys()) {
            for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                Object oo = this.getRawValue(fallbackKey.getKey());
                if (oo == null) continue;
                this.loggingFallback(fallbackKey, configOption);
                return oo;
            }
        }
        return null;
    }

    private Object getValueOrDefaultFromOption(ConfigOption<?> configOption) {
        Object o = this.getRawValueFromOption(configOption);
        return o != null ? o : configOption.defaultValue();
    }

    private void loggingFallback(FallbackKey fallbackKey, ConfigOption<?> configOption) {
        if (fallbackKey.isDeprecated()) {
            LOG.warn("Config uses deprecated configuration key '{}' instead of proper key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        } else {
            LOG.info("Config uses fallback configuration key '{}' instead of key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        }
    }

    private int convertToInt(Object o, int defaultValue) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            LOG.warn("Configuration value {} overflows/underflows the integer type.", (Object)value);
            return defaultValue;
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (NumberFormatException e) {
            LOG.warn("Configuration cannot evaluate value {} as an integer number", o);
            return defaultValue;
        }
    }

    private long convertToLong(Object o, long defaultValue) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException e) {
            LOG.warn("Configuration cannot evaluate value " + o + " as a long integer number");
            return defaultValue;
        }
    }

    private boolean convertToBoolean(Object o) {
        if (o.getClass() == Boolean.class) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    private float convertToFloat(Object o, float defaultValue) {
        if (o.getClass() == Float.class) {
            return ((Float)o).floatValue();
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return (float)value;
            }
            LOG.warn("Configuration value {} overflows/underflows the float type.", (Object)value);
            return defaultValue;
        }
        try {
            return Float.parseFloat(o.toString());
        }
        catch (NumberFormatException e) {
            LOG.warn("Configuration cannot evaluate value {} as a float value", o);
            return defaultValue;
        }
    }

    private double convertToDouble(Object o, double defaultValue) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException e) {
            LOG.warn("Configuration cannot evaluate value {} as a double value", o);
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputView in) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            int numberOfProperties = in.readInt();
            for (int i = 0; i < numberOfProperties; ++i) {
                Object value;
                String key = StringValue.readString(in);
                byte type = in.readByte();
                switch (type) {
                    case 0: {
                        value = StringValue.readString(in);
                        break;
                    }
                    case 1: {
                        value = in.readInt();
                        break;
                    }
                    case 2: {
                        value = in.readLong();
                        break;
                    }
                    case 4: {
                        value = Float.valueOf(in.readFloat());
                        break;
                    }
                    case 5: {
                        value = in.readDouble();
                        break;
                    }
                    case 3: {
                        value = in.readBoolean();
                        break;
                    }
                    case 6: {
                        byte[] bytes = new byte[in.readInt()];
                        in.readFully(bytes);
                        value = bytes;
                        break;
                    }
                    default: {
                        throw new IOException("Unrecognized type: " + type);
                    }
                }
                this.confData.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputView out) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            out.writeInt(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                StringValue.writeString(key, out);
                Class<?> clazz = val.getClass();
                if (clazz == String.class) {
                    out.write(0);
                    StringValue.writeString((String)val, out);
                    continue;
                }
                if (clazz == Integer.class) {
                    out.write(1);
                    out.writeInt((Integer)val);
                    continue;
                }
                if (clazz == Long.class) {
                    out.write(2);
                    out.writeLong((Long)val);
                    continue;
                }
                if (clazz == Float.class) {
                    out.write(4);
                    out.writeFloat(((Float)val).floatValue());
                    continue;
                }
                if (clazz == Double.class) {
                    out.write(5);
                    out.writeDouble((Double)val);
                    continue;
                }
                if (clazz == byte[].class) {
                    out.write(6);
                    byte[] bytes = (byte[])val;
                    out.writeInt(bytes.length);
                    out.write(bytes);
                    continue;
                }
                if (clazz == Boolean.class) {
                    out.write(3);
                    out.writeBoolean((Boolean)val);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized type");
            }
        }
    }

    public int hashCode() {
        int hash = 0;
        for (String s : this.confData.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configuration) {
            HashMap<String, Object> otherConf = ((Configuration)obj).confData;
            for (Map.Entry<String, Object> e : this.confData.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.confData.toString();
    }
}

