/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

@PublicEvolving
public class WebOptions {
    public static final ConfigOption<String> ADDRESS = ConfigOptions.key("web.address").noDefaultValue().withDeprecatedKeys("jobmanager.web.address").withDescription("Address for runtime monitor web-frontend server.");
    @Deprecated
    public static final ConfigOption<Integer> PORT = ConfigOptions.key("web.port").defaultValue(8081).withDeprecatedKeys("jobmanager.web.port");
    public static final ConfigOption<String> ACCESS_CONTROL_ALLOW_ORIGIN = ConfigOptions.key("web.access-control-allow-origin").defaultValue("*").withDeprecatedKeys("jobmanager.web.access-control-allow-origin").withDescription("Access-Control-Allow-Origin header for all responses from the web-frontend.");
    public static final ConfigOption<Long> REFRESH_INTERVAL = ConfigOptions.key("web.refresh-interval").defaultValue(3000L).withDeprecatedKeys("jobmanager.web.refresh-interval").withDescription("Refresh interval for the web-frontend in milliseconds.");
    public static final ConfigOption<Boolean> SSL_ENABLED = ConfigOptions.key("web.ssl.enabled").defaultValue(true).withDeprecatedKeys("jobmanager.web.ssl.enabled").withDescription("Flag indicating whether to override SSL support for the JobManager Web UI.");
    @Documentation.OverrideDefault(value="System.getProperty(\"java.io.tmpdir\")")
    public static final ConfigOption<String> TMP_DIR = ConfigOptions.key("web.tmpdir").defaultValue(System.getProperty("java.io.tmpdir")).withDeprecatedKeys("jobmanager.web.tmpdir").withDescription("Flink web directory which is used by the webmonitor.");
    public static final ConfigOption<String> UPLOAD_DIR = ConfigOptions.key("web.upload.dir").noDefaultValue().withDeprecatedKeys("jobmanager.web.upload.dir").withDescription("Directory for uploading the job jars. If not specified a dynamic directory will be used under the directory specified by JOB_MANAGER_WEB_TMPDIR_KEY.");
    public static final ConfigOption<Integer> ARCHIVE_COUNT = ConfigOptions.key("web.history").defaultValue(5).withDeprecatedKeys("jobmanager.web.history").withDescription("Number of archived jobs for the JobManager.");
    public static final ConfigOption<String> LOG_PATH = ConfigOptions.key("web.log.path").noDefaultValue().withDeprecatedKeys("jobmanager.web.log.path").withDescription("Path to the log file (may be in /log for standalone but under log directory when using YARN).");
    public static final ConfigOption<Boolean> SUBMIT_ENABLE = ConfigOptions.key("web.submit.enable").defaultValue(true).withDeprecatedKeys("jobmanager.web.submit.enable").withDescription("Flag indicating whether jobs can be uploaded and run from the web-frontend.");
    public static final ConfigOption<Integer> CHECKPOINTS_HISTORY_SIZE = ConfigOptions.key("web.checkpoints.history").defaultValue(10).withDeprecatedKeys("jobmanager.web.checkpoints.history").withDescription("Number of checkpoints to remember for recent history.");
    public static final ConfigOption<Integer> BACKPRESSURE_CLEANUP_INTERVAL = ConfigOptions.key("web.backpressure.cleanup-interval").defaultValue(600000).withDeprecatedKeys("jobmanager.web.backpressure.cleanup-interval").withDescription("Time, in milliseconds, after which cached stats are cleaned up if not accessed.");
    public static final ConfigOption<Integer> BACKPRESSURE_REFRESH_INTERVAL = ConfigOptions.key("web.backpressure.refresh-interval").defaultValue(60000).withDeprecatedKeys("jobmanager.web.backpressure.refresh-interval").withDescription("Time, in milliseconds, after which available stats are deprecated and need to be refreshed (by resampling).");
    public static final ConfigOption<Integer> BACKPRESSURE_NUM_SAMPLES = ConfigOptions.key("web.backpressure.num-samples").defaultValue(100).withDeprecatedKeys("jobmanager.web.backpressure.num-samples").withDescription("Number of stack trace samples to take to determine back pressure.");
    public static final ConfigOption<Integer> BACKPRESSURE_DELAY = ConfigOptions.key("web.backpressure.delay-between-samples").defaultValue(50).withDeprecatedKeys("jobmanager.web.backpressure.delay-between-samples").withDescription("Delay between stack trace samples to determine back pressure in milliseconds.");
    public static final ConfigOption<Long> TIMEOUT = ConfigOptions.key("web.timeout").defaultValue(10000L).withDescription("Timeout for asynchronous operations by the web monitor in milliseconds.");

    private WebOptions() {
    }
}

