/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.plugin.Plugin;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.TemporaryClassLoaderContext;
import org.apache.flink.util.ArrayUtils;
import org.apache.flink.util.ChildFirstClassLoader;

@ThreadSafe
public class PluginLoader {
    private final ClassLoader pluginClassLoader;

    @VisibleForTesting
    public PluginLoader(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
    }

    @VisibleForTesting
    public static ClassLoader createPluginClassLoader(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new ChildFirstClassLoader(pluginDescriptor.getPluginResourceURLs(), parentClassLoader, ArrayUtils.concat(alwaysParentFirstPatterns, pluginDescriptor.getLoaderExcludePatterns()));
    }

    public static PluginLoader create(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new PluginLoader(PluginLoader.createPluginClassLoader(pluginDescriptor, parentClassLoader, alwaysParentFirstPatterns));
    }

    public <P extends Plugin> Iterator<P> load(Class<P> service) {
        try (TemporaryClassLoaderContext classLoaderContext = new TemporaryClassLoaderContext(this.pluginClassLoader);){
            ContextClassLoaderSettingIterator<P> contextClassLoaderSettingIterator = new ContextClassLoaderSettingIterator<P>(ServiceLoader.load(service, this.pluginClassLoader).iterator(), this.pluginClassLoader);
            return contextClassLoaderSettingIterator;
        }
    }

    static class ContextClassLoaderSettingIterator<P extends Plugin>
    implements Iterator<P> {
        private final Iterator<P> delegate;
        private final ClassLoader pluginClassLoader;

        ContextClassLoaderSettingIterator(Iterator<P> delegate, ClassLoader pluginClassLoader) {
            this.delegate = delegate;
            this.pluginClassLoader = pluginClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public P next() {
            try (TemporaryClassLoaderContext classLoaderContext = new TemporaryClassLoaderContext(this.pluginClassLoader);){
                Plugin plugin = (Plugin)this.delegate.next();
                return (P)plugin;
            }
        }
    }
}

