/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.DirectoryBasedPluginFinder;
import org.apache.flink.core.plugin.PluginConfig;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.util.FlinkRuntimeException;

public final class PluginUtils {
    private PluginUtils() {
        throw new AssertionError((Object)"Singleton class.");
    }

    public static PluginManager createPluginManagerFromRootFolder(Configuration configuration) {
        return PluginUtils.createPluginManagerFromRootFolder(PluginConfig.fromConfiguration(configuration));
    }

    private static PluginManager createPluginManagerFromRootFolder(PluginConfig pluginConfig) {
        if (pluginConfig.getPluginsPath().isPresent()) {
            try {
                Collection<PluginDescriptor> pluginDescriptors = new DirectoryBasedPluginFinder(pluginConfig.getPluginsPath().get()).findPlugins();
                return new PluginManager(pluginDescriptors, pluginConfig.getAlwaysParentFirstPatterns());
            }
            catch (IOException e) {
                throw new FlinkRuntimeException("Exception when trying to initialize plugin system.", e);
            }
        }
        return new PluginManager(Collections.emptyList(), pluginConfig.getAlwaysParentFirstPatterns());
    }
}

