/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Arrays;
import java.util.List;

public enum MemoryArchitecture {
    _32_BIT,
    _64_BIT,
    UNKNOWN;

    private static final MemoryArchitecture current;

    public static MemoryArchitecture get() {
        return current;
    }

    private static MemoryArchitecture getInternal() {
        List<String> names64bit = Arrays.asList("amd64", "x86_64", "aarch64");
        List<String> names32bit = Arrays.asList("x86", "i386", "i486", "i586", "i686");
        String arch = System.getProperty("os.arch");
        if (names64bit.contains(arch)) {
            return _64_BIT;
        }
        if (names32bit.contains(arch)) {
            return _32_BIT;
        }
        return UNKNOWN;
    }

    static {
        current = MemoryArchitecture.getInternal();
    }
}

