/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.Duration;
import java.util.Locale;
import org.apache.flink.util.Preconditions;

public class TimeUtils {
    public static Duration parseDuration(String text) {
        long multiplier;
        long value;
        char current;
        int pos;
        Preconditions.checkNotNull(text, "text");
        String trimmed = text.trim();
        Preconditions.checkArgument(!trimmed.isEmpty(), "argument is an empty- or whitespace-only string");
        int len = trimmed.length();
        for (pos = 0; pos < len && (current = trimmed.charAt(pos)) >= '0' && current <= '9'; ++pos) {
        }
        String number = trimmed.substring(0, pos);
        String unit = trimmed.substring(pos).trim().toLowerCase(Locale.US);
        if (number.isEmpty()) {
            throw new NumberFormatException("text does not start with a number");
        }
        try {
            value = Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The value '" + number + "' cannot be re represented as 64bit number (numeric overflow).");
        }
        if (unit.isEmpty()) {
            multiplier = 1L;
        } else if (TimeUtils.matchTimeUnit(unit, TimeUnit.MILLISECONDS)) {
            multiplier = 1L;
        } else if (TimeUtils.matchTimeUnit(unit, TimeUnit.SECONDS)) {
            multiplier = 1000L;
        } else if (TimeUtils.matchTimeUnit(unit, TimeUnit.MINUTES)) {
            multiplier = 60000L;
        } else if (TimeUtils.matchTimeUnit(unit, TimeUnit.HOURS)) {
            multiplier = 3600000L;
        } else {
            throw new IllegalArgumentException("Time interval unit '" + unit + "' does not match any of the recognized units: " + TimeUnit.getAllUnits());
        }
        long result = value * multiplier;
        if (result / multiplier != value) {
            throw new IllegalArgumentException("The value '" + text + "' cannot be re represented as 64bit number of bytes (numeric overflow).");
        }
        return Duration.ofMillis(result);
    }

    private static boolean matchTimeUnit(String text, TimeUnit unit) {
        return text.equals(unit.getUnit());
    }

    private static enum TimeUnit {
        MILLISECONDS("ms"),
        SECONDS("s"),
        MINUTES("min"),
        HOURS("h");

        private String unit;

        private TimeUnit(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public static String getAllUnits() {
            return String.join((CharSequence)" | ", MILLISECONDS.getUnit(), SECONDS.getUnit(), MINUTES.getUnit(), HOURS.getUnit());
        }
    }
}

