/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.function;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class FunctionUtils {
    private static final Function<Object, Void> NULL_FN = ignored -> null;
    private static final Consumer<Object> IGNORE_FN = ignored -> {};

    private FunctionUtils() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    public static <T> Function<T, Void> nullFn() {
        return NULL_FN;
    }

    public static <T> Consumer<T> ignoreFn() {
        return IGNORE_FN;
    }

    public static <A, B> Function<A, B> uncheckedFunction(FunctionWithException<A, B, ?> functionWithException) {
        return value -> {
            try {
                return functionWithException.apply(value);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow(t);
                return null;
            }
        };
    }

    public static <A> Consumer<A> uncheckedConsumer(ThrowingConsumer<A, ?> throwingConsumer) {
        return value -> {
            try {
                throwingConsumer.accept(value);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow(t);
            }
        };
    }

    public static <T> Supplier<T> uncheckedSupplier(SupplierWithException<T, ?> supplierWithException) {
        return () -> {
            Object result = null;
            try {
                result = supplierWithException.get();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow(t);
            }
            return result;
        };
    }
}

