/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

public class HBaseOptions {
    private final String tableName;
    private final String zkQuorum;
    @Nullable
    private final String zkNodeParent;

    private HBaseOptions(String tableName, String zkQuorum, @Nullable String zkNodeParent) {
        this.tableName = tableName;
        this.zkQuorum = zkQuorum;
        this.zkNodeParent = zkNodeParent;
    }

    String getTableName() {
        return this.tableName;
    }

    String getZkQuorum() {
        return this.zkQuorum;
    }

    Optional<String> getZkNodeParent() {
        return Optional.ofNullable(this.zkNodeParent);
    }

    public String toString() {
        return "HBaseOptions{tableName='" + this.tableName + '\'' + ", zkQuorum='" + this.zkQuorum + '\'' + ", zkNodeParent='" + this.zkNodeParent + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HBaseOptions that = (HBaseOptions)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.zkQuorum, that.zkQuorum) && Objects.equals(this.zkNodeParent, that.zkNodeParent);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.zkQuorum, this.zkNodeParent);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String tableName;
        private String zkQuorum;
        private String zkNodeParent;

        public Builder setTableName(String tableName) {
            Preconditions.checkNotNull((Object)tableName);
            this.tableName = tableName;
            return this;
        }

        public Builder setZkQuorum(String zkQuorum) {
            Preconditions.checkNotNull((Object)zkQuorum);
            this.zkQuorum = zkQuorum;
            return this;
        }

        public Builder setZkNodeParent(String zkNodeParent) {
            Preconditions.checkNotNull((Object)zkNodeParent);
            this.zkNodeParent = zkNodeParent;
            return this;
        }

        public HBaseOptions build() {
            Preconditions.checkNotNull((Object)this.zkQuorum, (String)"Zookeeper quorum is not set.");
            Preconditions.checkNotNull((Object)this.tableName, (String)"TableName is not set.");
            return new HBaseOptions(this.tableName, this.zkQuorum, this.zkNodeParent);
        }
    }
}

