/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.addons.hbase.util.HBaseTypeUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.util.Preconditions;

public class HBaseTableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, TypeInformation<?>>> familyMap = new LinkedHashMap();
    private RowKeyInfo rowKeyInfo;
    private String charset = "UTF-8";

    public void addColumn(String family, String qualifier, Class<?> clazz) {
        Preconditions.checkNotNull((Object)family, (String)"family name");
        Preconditions.checkNotNull((Object)qualifier, (String)"qualifier name");
        Preconditions.checkNotNull(clazz, (String)"class type");
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (!HBaseTypeUtils.isSupportedType(clazz)) {
            throw new IllegalArgumentException("Unsupported class type found " + clazz + ". Better to use byte[].class and deserialize using user defined scalar functions");
        }
        if (qualifierMap == null) {
            qualifierMap = new LinkedHashMap();
        }
        qualifierMap.put(qualifier, TypeExtractor.getForClass(clazz));
        this.familyMap.put(family, qualifierMap);
    }

    public void setRowKey(String rowKeyName, Class<?> clazz) {
        Preconditions.checkNotNull((Object)rowKeyName, (String)"row key field name");
        Preconditions.checkNotNull(clazz, (String)"row key class type");
        if (!HBaseTypeUtils.isSupportedType(clazz)) {
            throw new IllegalArgumentException("Unsupported class type found " + clazz + ". Better to use byte[].class and deserialize using user defined scalar functions");
        }
        if (this.rowKeyInfo != null) {
            throw new IllegalArgumentException("Row key can't be set multiple times.");
        }
        this.rowKeyInfo = new RowKeyInfo(rowKeyName, TypeExtractor.getForClass(clazz), this.familyMap.size());
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String[] getFamilyNames() {
        return this.familyMap.keySet().toArray(new String[0]);
    }

    public byte[][] getFamilyKeys() {
        Charset c = Charset.forName(this.charset);
        byte[][] familyKeys = new byte[this.familyMap.size()][];
        int i = 0;
        for (String name : this.familyMap.keySet()) {
            familyKeys[i++] = name.getBytes(c);
        }
        return familyKeys;
    }

    String[] getQualifierNames(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        String[] qualifierNames = new String[qualifierMap.size()];
        int i = 0;
        Iterator<String> iterator = qualifierMap.keySet().iterator();
        while (iterator.hasNext()) {
            String qualifier;
            qualifierNames[i] = qualifier = iterator.next();
            ++i;
        }
        return qualifierNames;
    }

    public byte[][] getQualifierKeys(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        Charset c = Charset.forName(this.charset);
        byte[][] qualifierKeys = new byte[qualifierMap.size()][];
        int i = 0;
        for (String name : qualifierMap.keySet()) {
            qualifierKeys[i++] = name.getBytes(c);
        }
        return qualifierKeys;
    }

    public TypeInformation<?>[] getQualifierTypes(String family) {
        Map<String, TypeInformation<?>> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        TypeInformation[] typeInformation = new TypeInformation[qualifierMap.size()];
        int i = 0;
        Iterator<TypeInformation<?>> iterator = qualifierMap.values().iterator();
        while (iterator.hasNext()) {
            TypeInformation<?> typeInfo;
            typeInformation[i] = typeInfo = iterator.next();
            ++i;
        }
        return typeInformation;
    }

    private Map<String, TypeInformation<?>> getFamilyInfo(String family) {
        return this.familyMap.get(family);
    }

    public String getStringCharset() {
        return this.charset;
    }

    public int getRowKeyIndex() {
        return this.rowKeyInfo == null ? -1 : this.rowKeyInfo.rowKeyIndex;
    }

    public Optional<TypeInformation<?>> getRowKeyTypeInfo() {
        return this.rowKeyInfo == null ? Optional.empty() : Optional.of(this.rowKeyInfo.rowKeyType);
    }

    Optional<String> getRowKeyName() {
        return this.rowKeyInfo == null ? Optional.empty() : Optional.of(this.rowKeyInfo.rowKeyName);
    }

    HBaseTableSchema getProjectedHBaseTableSchema(int[] projectedFields) {
        if (projectedFields == null) {
            return this;
        }
        HBaseTableSchema newSchema = new HBaseTableSchema();
        String[] fieldNames = this.convertsToTableSchema().getFieldNames();
        for (int projectedField : projectedFields) {
            String name = fieldNames[projectedField];
            if (this.rowKeyInfo != null && name.equals(this.rowKeyInfo.rowKeyName)) {
                newSchema.setRowKey(this.rowKeyInfo.rowKeyName, this.rowKeyInfo.rowKeyType.getTypeClass());
                continue;
            }
            Map<String, TypeInformation<?>> familyInfo = this.getFamilyInfo(name);
            for (Map.Entry<String, TypeInformation<?>> entry : familyInfo.entrySet()) {
                String qualifier = entry.getKey();
                newSchema.addColumn(name, qualifier, entry.getValue().getTypeClass());
            }
        }
        newSchema.setCharset(this.charset);
        return newSchema;
    }

    TableSchema convertsToTableSchema() {
        String[] familyNames = this.getFamilyNames();
        if (this.rowKeyInfo != null) {
            String[] fieldNames = new String[familyNames.length + 1];
            TypeInformation[] fieldTypes = new TypeInformation[familyNames.length + 1];
            for (int i = 0; i < fieldNames.length; ++i) {
                String family;
                if (i == this.rowKeyInfo.rowKeyIndex) {
                    fieldNames[i] = this.rowKeyInfo.rowKeyName;
                    fieldTypes[i] = this.rowKeyInfo.rowKeyType;
                    continue;
                }
                int familyIndex = i < this.rowKeyInfo.rowKeyIndex ? i : i - 1;
                fieldNames[i] = family = familyNames[familyIndex];
                fieldTypes[i] = new RowTypeInfo(this.getQualifierTypes(family), this.getQualifierNames(family));
            }
            return new TableSchema(fieldNames, fieldTypes);
        }
        String[] fieldNames = new String[familyNames.length];
        TypeInformation[] fieldTypes = new TypeInformation[familyNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String family;
            fieldNames[i] = family = familyNames[i];
            fieldTypes[i] = new RowTypeInfo(this.getQualifierTypes(family), this.getQualifierNames(family));
        }
        return new TableSchema(fieldNames, fieldTypes);
    }

    private static class RowKeyInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String rowKeyName;
        final TypeInformation<?> rowKeyType;
        final int rowKeyIndex;

        RowKeyInfo(String rowKeyName, TypeInformation<?> rowKeyType, int rowKeyIndex) {
            this.rowKeyName = rowKeyName;
            this.rowKeyType = rowKeyType;
            this.rowKeyIndex = rowKeyIndex;
        }
    }
}

