/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase;

import java.util.Arrays;
import org.apache.flink.addons.hbase.HBaseOptions;
import org.apache.flink.addons.hbase.HBaseTableSchema;
import org.apache.flink.addons.hbase.HBaseUpsertSinkFunction;
import org.apache.flink.addons.hbase.HBaseWriteOptions;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

public class HBaseUpsertTableSink
implements UpsertStreamTableSink<Row> {
    private final HBaseTableSchema hbaseTableSchema;
    private final TableSchema tableSchema;
    private final HBaseOptions hbaseOptions;
    private final HBaseWriteOptions writeOptions;

    public HBaseUpsertTableSink(HBaseTableSchema hbaseTableSchema, HBaseOptions hbaseOptions, HBaseWriteOptions writeOptions) {
        Preconditions.checkArgument((boolean)hbaseTableSchema.getRowKeyName().isPresent(), (Object)"HBaseUpsertTableSink requires rowkey is set.");
        this.hbaseTableSchema = hbaseTableSchema;
        this.tableSchema = hbaseTableSchema.convertsToTableSchema();
        this.hbaseOptions = hbaseOptions;
        this.writeOptions = writeOptions;
    }

    public void setKeyFields(String[] keys) {
    }

    public void setIsAppendOnly(Boolean isAppendOnly) {
    }

    public TypeInformation<Row> getRecordType() {
        return this.tableSchema.toRowType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        Configuration hbaseClientConf = HBaseConfiguration.create();
        hbaseClientConf.set("hbase.zookeeper.quorum", this.hbaseOptions.getZkQuorum());
        this.hbaseOptions.getZkNodeParent().ifPresent(v -> hbaseClientConf.set("zookeeper.znode.parent", v));
        HBaseUpsertSinkFunction sinkFunction = new HBaseUpsertSinkFunction(this.hbaseOptions.getTableName(), this.hbaseTableSchema, hbaseClientConf, this.writeOptions.getBufferFlushMaxSizeInBytes(), this.writeOptions.getBufferFlushMaxRows(), this.writeOptions.getBufferFlushIntervalMillis());
        return dataStream.addSink((SinkFunction)sinkFunction).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.tableSchema.getFieldNames()));
    }

    public void emitDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        this.consumeDataStream(dataStream);
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        if (!Arrays.equals(this.getFieldNames(), fieldNames) || !Arrays.equals(this.getFieldTypes(), fieldTypes)) {
            throw new ValidationException("Reconfiguration with different fields is not allowed. Expected: " + Arrays.toString(this.getFieldNames()) + " / " + Arrays.toString(this.getFieldTypes()) + ". But was: " + Arrays.toString(fieldNames) + " / " + Arrays.toString(fieldTypes));
        }
        return new HBaseUpsertTableSink(this.hbaseTableSchema, this.hbaseOptions, this.writeOptions);
    }

    @VisibleForTesting
    HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseTableSchema;
    }

    @VisibleForTesting
    HBaseOptions getHBaseOptions() {
        return this.hbaseOptions;
    }

    @VisibleForTesting
    HBaseWriteOptions getWriteOptions() {
        return this.writeOptions;
    }
}

