/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.addons.hbase.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.hadoop.hbase.util.Bytes;

@Internal
public class HBaseTypeUtils {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static Object deserializeToObject(byte[] value, int typeIdx, Charset stringCharset) {
        switch (typeIdx) {
            case 0: {
                return value;
            }
            case 1: {
                return new String(value, stringCharset);
            }
            case 2: {
                return value[0];
            }
            case 3: {
                return Bytes.toShort((byte[])value);
            }
            case 4: {
                return Bytes.toInt((byte[])value);
            }
            case 5: {
                return Bytes.toLong((byte[])value);
            }
            case 6: {
                return Float.valueOf(Bytes.toFloat((byte[])value));
            }
            case 7: {
                return Bytes.toDouble((byte[])value);
            }
            case 8: {
                return Bytes.toBoolean((byte[])value);
            }
            case 9: {
                return new Timestamp(Bytes.toLong((byte[])value));
            }
            case 10: {
                return new Date(Bytes.toLong((byte[])value));
            }
            case 11: {
                return new Time(Bytes.toLong((byte[])value));
            }
            case 12: {
                return Bytes.toBigDecimal((byte[])value);
            }
            case 13: {
                return new BigInteger(value);
            }
        }
        throw new IllegalArgumentException("unsupported type index:" + typeIdx);
    }

    public static byte[] serializeFromObject(Object value, int typeIdx, Charset stringCharset) {
        switch (typeIdx) {
            case 0: {
                return (byte[])value;
            }
            case 1: {
                return value == null ? EMPTY_BYTES : ((String)value).getBytes(stringCharset);
            }
            case 2: {
                byte[] byArray;
                if (value == null) {
                    byArray = EMPTY_BYTES;
                } else {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = (Byte)value;
                }
                return byArray;
            }
            case 3: {
                return Bytes.toBytes((short)((Short)value));
            }
            case 4: {
                return Bytes.toBytes((int)((Integer)value));
            }
            case 5: {
                return Bytes.toBytes((long)((Long)value));
            }
            case 6: {
                return Bytes.toBytes((float)((Float)value).floatValue());
            }
            case 7: {
                return Bytes.toBytes((double)((Double)value));
            }
            case 8: {
                return Bytes.toBytes((boolean)((Boolean)value));
            }
            case 9: {
                return Bytes.toBytes((long)((Timestamp)value).getTime());
            }
            case 10: {
                return Bytes.toBytes((long)((Date)value).getTime());
            }
            case 11: {
                return Bytes.toBytes((long)((Time)value).getTime());
            }
            case 12: {
                return Bytes.toBytes((BigDecimal)((BigDecimal)value));
            }
            case 13: {
                return ((BigInteger)value).toByteArray();
            }
        }
        throw new IllegalArgumentException("unsupported type index:" + typeIdx);
    }

    public static int getTypeIndex(TypeInformation typeInfo) {
        return HBaseTypeUtils.getTypeIndex(typeInfo.getTypeClass());
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return HBaseTypeUtils.getTypeIndex(clazz) != -1;
    }

    private static int getTypeIndex(Class<?> clazz) {
        if (byte[].class.equals(clazz)) {
            return 0;
        }
        if (String.class.equals(clazz)) {
            return 1;
        }
        if (Byte.class.equals(clazz)) {
            return 2;
        }
        if (Short.class.equals(clazz)) {
            return 3;
        }
        if (Integer.class.equals(clazz)) {
            return 4;
        }
        if (Long.class.equals(clazz)) {
            return 5;
        }
        if (Float.class.equals(clazz)) {
            return 6;
        }
        if (Double.class.equals(clazz)) {
            return 7;
        }
        if (Boolean.class.equals(clazz)) {
            return 8;
        }
        if (Timestamp.class.equals(clazz)) {
            return 9;
        }
        if (Date.class.equals(clazz)) {
            return 10;
        }
        if (Time.class.equals(clazz)) {
            return 11;
        }
        if (BigDecimal.class.equals(clazz)) {
            return 12;
        }
        if (BigInteger.class.equals(clazz)) {
            return 13;
        }
        return -1;
    }
}

