/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.streaming.runtime.io.BufferOrEventSequence;
import org.apache.flink.streaming.runtime.io.BufferStorage;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractBufferStorage
implements BufferStorage {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractBufferStorage.class);
    protected final ArrayDeque<BufferOrEventSequence> queuedBuffered = new ArrayDeque();
    protected final long maxBufferedBytes;
    protected final String taskName;
    protected BufferOrEventSequence currentBuffered;
    protected long rolledBytes;

    protected AbstractBufferStorage(long maxBufferedBytes, String taskName) {
        Preconditions.checkArgument((maxBufferedBytes == -1L || maxBufferedBytes > 0L ? 1 : 0) != 0);
        this.maxBufferedBytes = maxBufferedBytes;
        this.taskName = taskName;
    }

    @Override
    public boolean isFull() {
        return this.maxBufferedBytes > 0L && this.getRolledBytes() + this.getPendingBytes() > this.maxBufferedBytes;
    }

    @Override
    public void rollOver() throws IOException {
        if (this.currentBuffered == null) {
            this.currentBuffered = this.rollOverReusingResources();
            if (this.currentBuffered != null) {
                this.currentBuffered.open();
            }
        } else {
            LOG.debug("{}: Checkpoint skipped via buffered data:Pushing back current alignment buffers and feeding back new alignment data first.", (Object)this.taskName);
            BufferOrEventSequence bufferedNow = this.rollOverWithoutReusingResources();
            if (bufferedNow != null) {
                bufferedNow.open();
                this.queuedBuffered.addFirst(this.currentBuffered);
                this.rolledBytes += this.currentBuffered.size();
                this.currentBuffered = bufferedNow;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Size of buffered data: {} bytes", (Object)this.taskName, (Object)(this.currentBuffered == null ? 0L : this.currentBuffered.size()));
        }
    }

    protected abstract BufferOrEventSequence rollOverWithoutReusingResources() throws IOException;

    protected abstract BufferOrEventSequence rollOverReusingResources() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.currentBuffered != null) {
            this.currentBuffered.cleanup();
        }
        for (BufferOrEventSequence seq : this.queuedBuffered) {
            seq.cleanup();
        }
        this.queuedBuffered.clear();
        this.rolledBytes = 0L;
    }

    @Override
    public long getRolledBytes() {
        return this.rolledBytes;
    }

    @Override
    public boolean isEmpty() {
        return this.currentBuffered == null;
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException {
        if (this.currentBuffered == null) {
            return Optional.empty();
        }
        Optional<BufferOrEvent> next = Optional.ofNullable(this.currentBuffered.getNext());
        if (!next.isPresent()) {
            this.completeBufferedSequence();
        }
        return next;
    }

    protected void completeBufferedSequence() throws IOException {
        LOG.debug("{}: Finished feeding back buffered data.", (Object)this.taskName);
        this.currentBuffered.cleanup();
        this.currentBuffered = this.queuedBuffered.pollFirst();
        if (this.currentBuffered != null) {
            this.currentBuffered.open();
            this.rolledBytes -= this.currentBuffered.size();
        }
    }

    @Override
    public long getMaxBufferedBytes() {
        return this.maxBufferedBytes;
    }
}

