/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import org.apache.nifi.remote.PeerDescription;

public class PeerStatus {
    private final PeerDescription description;
    private final int numFlowFiles;
    private final boolean queryForPeers;

    public PeerStatus(PeerDescription description, int numFlowFiles, boolean queryForPeers) {
        this.description = description;
        this.numFlowFiles = numFlowFiles;
        this.queryForPeers = queryForPeers;
    }

    public PeerDescription getPeerDescription() {
        return this.description;
    }

    public int getFlowFileCount() {
        return this.numFlowFiles;
    }

    public boolean isQueryForPeers() {
        return this.queryForPeers;
    }

    public String toString() {
        return "PeerStatus[hostname=" + this.description.getHostname() + ",port=" + this.description.getPort() + ",secure=" + this.description.isSecure() + ",flowFileCount=" + this.numFlowFiles + "]";
    }

    public int hashCode() {
        return 9824372 + this.description.getHostname().hashCode() + this.description.getPort() * 41;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PeerStatus)) {
            return false;
        }
        PeerStatus other = (PeerStatus)obj;
        return this.description.equals(other.getPeerDescription());
    }
}

