/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.rawsockets.attic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.SystemUtils;
import org.apache.plc4x.java.utils.pcap.netty.exception.PcapException;
import org.apache.plc4x.java.utils.rawsockets.attic.RawSocketListener;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ArpPacket;
import org.pcap4j.packet.EthernetPacket;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV4Rfc791Tos;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.ArpOperation;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawIpSocket {
    private static final Logger logger = LoggerFactory.getLogger(RawIpSocket.class);
    private static final int SNAPLEN = 65536;
    private static final int READ_TIMEOUT = 10000;
    private static final String GATEWAY_ONLY_NETMASK = "255.255.255.255";
    private static final Map<InetAddress, MacAddress> arpCache = new HashMap<InetAddress, MacAddress>();
    private final int protocolNumber;
    private PcapNetworkInterface nif;
    private InetAddress remoteIpAddress;
    private MacAddress firstHopMacAddress;
    private InetAddress localIpAddress;
    private MacAddress localMacAddress;
    private ExecutorService pool = Executors.newSingleThreadExecutor();
    private PcapHandle receiveHandle;
    private final List<RawSocketListener> listeners = new LinkedList<RawSocketListener>();

    public RawIpSocket(int protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public void connect(String remoteAddress) throws PcapException {
        try {
            this.pool = Executors.newScheduledThreadPool(2);
            this.remoteIpAddress = InetAddress.getByName(remoteAddress);
            FirstHop firstHop = this.getFirstHop(this.remoteIpAddress);
            if (firstHop == null) {
                InetAddress defaultGatewayAddress = this.getDefaultGatewayAddress();
                if (defaultGatewayAddress != null) {
                    firstHop = this.getFirstHop(defaultGatewayAddress);
                    if (firstHop == null) {
                        throw new PcapException("Unable to connect to " + remoteAddress);
                    }
                } else {
                    throw new PcapException("Unable to connect to " + remoteAddress + " no default gateway");
                }
            }
            this.nif = firstHop.networkInterface;
            if (this.nif.isLoopBack()) {
                throw new PcapException("Can't use RawSocket on loopback devices");
            }
            this.localMacAddress = MacAddress.getByAddress((byte[])firstHop.localMacAddress.getAddress());
            this.localIpAddress = firstHop.localInetAddress;
            this.firstHopMacAddress = MacAddress.getByAddress((byte[])firstHop.remoteMacAddress.getAddress());
            this.receiveHandle = this.nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10000);
            String filterString = "ip protochain " + this.protocolNumber + " and ether dst " + this.localMacAddress.toString() + " and ip dst " + this.localIpAddress.getHostAddress() + " and ether src " + this.firstHopMacAddress.toString() + " and ip src " + this.remoteIpAddress.getHostAddress();
            this.receiveHandle.setFilter(filterString, BpfProgram.BpfCompileMode.OPTIMIZE);
            PacketListener packetListener = packet -> {
                for (RawSocketListener listener : this.listeners) {
                    listener.packetReceived(packet.getRawData());
                }
            };
            this.pool.execute(() -> {
                try {
                    this.receiveHandle.loop(-1, packetListener);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error("Error receiving packet for protocol {} from MAC address {}", new Object[]{this.protocolNumber, this.firstHopMacAddress, e});
                }
                catch (NotOpenException | PcapNativeException e) {
                    logger.error("Error receiving packet for protocol {} from MAC address {}", new Object[]{this.protocolNumber, this.firstHopMacAddress, e});
                }
            });
        }
        catch (UnknownHostException | NotOpenException | PcapNativeException e) {
            throw new PcapException("Error setting up RawSocket", e);
        }
    }

    public void disconnect() throws PcapException {
    }

    public void write(byte[] rawData) throws PcapException {
        try (PcapHandle sendHandle = this.nif.openLive(65536, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10000);){
            UnknownPacket.Builder packetBuilder = new UnknownPacket.Builder();
            packetBuilder.rawData(rawData);
            final IpV4Packet.Builder ipV4Builder = new IpV4Packet.Builder();
            ipV4Builder.version(IpVersion.IPV4).tos((IpV4Packet.IpV4Tos)IpV4Rfc791Tos.newInstance((byte)0)).ttl((byte)100).protocol(new IpNumber(Byte.valueOf((byte)this.protocolNumber), "plc4x")).srcAddr((Inet4Address)this.localIpAddress).dstAddr((Inet4Address)this.remoteIpAddress).payloadBuilder((Packet.Builder)packetBuilder).correctChecksumAtBuild(true).correctLengthAtBuild(true);
            ipV4Builder.identification((short)1);
            EthernetPacket.Builder etherBuilder = new EthernetPacket.Builder();
            etherBuilder.dstAddr(this.firstHopMacAddress).srcAddr(this.localMacAddress).type(EtherType.IPV4).paddingAtBuild(true);
            etherBuilder.payloadBuilder((Packet.Builder)new AbstractPacket.AbstractBuilder(){

                public Packet build() {
                    return ipV4Builder.build();
                }
            });
            EthernetPacket p = etherBuilder.build();
            sendHandle.sendPacket((Packet)p);
        }
        catch (NotOpenException | PcapNativeException e) {
            throw new PcapException("Error sending packet.", e);
        }
    }

    public void addListener(RawSocketListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(RawSocketListener listener) {
        this.listeners.remove(listener);
    }

    private MacAddress getMacAddress(PcapNetworkInterface dev, InetAddress localIpAddress, InetAddress remoteIpAddress) throws PcapException {
        if (!arpCache.containsKey(remoteIpAddress)) {
            MacAddress macAddress = this.lookupMacAddress(dev, localIpAddress, remoteIpAddress);
            arpCache.put(remoteIpAddress, macAddress);
            return macAddress;
        }
        return arpCache.get(remoteIpAddress);
    }

    /*
     * Exception decompiling
     */
    private MacAddress lookupMacAddress(PcapNetworkInterface dev, InetAddress localIpAddress, InetAddress remoteIpAddress) throws PcapException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FirstHop getFirstHop(InetAddress remoteAddress) throws PcapException {
        byte[] remoteIp = remoteAddress.getAddress();
        try {
            for (PcapNetworkInterface dev : Pcaps.findAllDevs()) {
                for (PcapAddress localAddress : dev.getAddresses()) {
                    if (GATEWAY_ONLY_NETMASK.equals(localAddress.getNetmask().getHostAddress())) {
                        return new FirstHop(dev, localAddress.getAddress(), (LinkLayerAddress)dev.getLinkLayerAddresses().iterator().next(), (LinkLayerAddress)this.getMacAddress(dev, localAddress.getAddress(), remoteAddress));
                    }
                    if (!remoteAddress.getClass().equals(localAddress.getAddress().getClass())) continue;
                    byte[] localIp = localAddress.getAddress().getAddress();
                    byte[] netMask = localAddress.getNetmask().getAddress();
                    boolean matches = true;
                    for (int i = 0; i < localIp.length; ++i) {
                        if ((localIp[i] & netMask[i]) == (remoteIp[i] & netMask[i])) continue;
                        matches = false;
                        break;
                    }
                    if (!matches || dev.getLinkLayerAddresses().isEmpty()) continue;
                    LinkLayerAddress localMacAddress = (LinkLayerAddress)dev.getLinkLayerAddresses().iterator().next();
                    return new FirstHop(dev, localAddress.getAddress(), localMacAddress, (LinkLayerAddress)this.getMacAddress(dev, localAddress.getAddress(), remoteAddress));
                }
            }
            return null;
        }
        catch (PcapNativeException e) {
            throw new PcapException("Error finding a device to communicate with remote address.", (Throwable)e);
        }
    }

    private InetAddress getDefaultGatewayAddress() {
        try {
            String s;
            int gatewayColumn;
            String linePrefix;
            Runtime rt = Runtime.getRuntime();
            String[] commands = new String[]{"netstat", "-rn"};
            Process proc = rt.exec(commands);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            if (SystemUtils.IS_OS_WINDOWS) {
                linePrefix = "0.0.0.0";
                gatewayColumn = 2;
            } else if (SystemUtils.IS_OS_MAC_OSX) {
                linePrefix = "default";
                gatewayColumn = 1;
            } else if (SystemUtils.IS_OS_LINUX) {
                linePrefix = "0.0.0.0";
                gatewayColumn = 1;
            } else {
                return null;
            }
            while ((s = stdInput.readLine()) != null) {
                if (!s.trim().startsWith(linePrefix)) continue;
                String[] columns = s.trim().split("\\s+");
                return InetAddress.getByName(columns[gatewayColumn]);
            }
        }
        catch (IOException e) {
            logger.debug("error caught", (Throwable)e);
            return null;
        }
        return null;
    }

    private static /* synthetic */ void lambda$lookupMacAddress$3(PcapHandle receiveHandle, PacketListener listener) {
        try {
            receiveHandle.loop(-1, listener);
        }
        catch (NotOpenException | PcapNativeException e) {
            logger.error("Error receiving ARP lookup", e);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted! Error receiving ARP lookup", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private static /* synthetic */ void lambda$lookupMacAddress$2(CompletableFuture resolutionFuture, Packet packet) {
        ArpPacket arp;
        if (packet.contains(ArpPacket.class) && (arp = (ArpPacket)packet.get(ArpPacket.class)).getHeader().getOperation().equals((Object)ArpOperation.REPLY)) {
            resolutionFuture.complete(arp.getHeader().getSrcHardwareAddr());
        }
    }

    private static class FirstHop {
        private final PcapNetworkInterface networkInterface;
        private final InetAddress localInetAddress;
        private final LinkLayerAddress localMacAddress;
        private final LinkLayerAddress remoteMacAddress;

        private FirstHop(PcapNetworkInterface networkInterface, InetAddress localInetAddress, LinkLayerAddress localMacAddress, LinkLayerAddress remoteMacAddress) {
            this.networkInterface = networkInterface;
            this.localInetAddress = localInetAddress;
            this.localMacAddress = localMacAddress;
            this.remoteMacAddress = remoteMacAddress;
        }
    }
}

