/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.utils.rawsockets.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.oio.OioByteStreamChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.utils.pcap.netty.exception.PcapException;
import org.apache.plc4x.java.utils.rawsockets.netty.address.RawSocketAddress;
import org.apache.plc4x.java.utils.rawsockets.netty.config.RawSocketChannelConfig;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.NotOpenException;
import org.pcap4j.core.PacketListener;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.packet.Packet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSocketChannel
extends OioByteStreamChannel {
    private static final Logger logger = LoggerFactory.getLogger(RawSocketChannel.class);
    private final RawSocketChannelConfig config = new RawSocketChannelConfig((Channel)this);
    private RawSocketAddress remoteRawSocketAddress;
    private SocketAddress localAddress;
    private PcapHandle handle;
    private Thread loopThread;

    public RawSocketChannel() {
        super(null);
    }

    protected boolean isInputShutdown() {
        return false;
    }

    protected ChannelFuture shutdownInput() {
        throw new NotImplementedException("");
    }

    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        String filter;
        if (!(remoteAddress instanceof RawSocketAddress)) {
            logger.error("Expecting remote address of type RawSocketAddress");
            this.pipeline().fireExceptionCaught((Throwable)new PcapException("Expecting remote address of type RawSocketAddress"));
            return;
        }
        this.localAddress = localAddress;
        this.remoteRawSocketAddress = (RawSocketAddress)((Object)remoteAddress);
        String deviceName = this.getDeviceName(this.remoteRawSocketAddress);
        if (deviceName == null) {
            logger.error("Network device not specified and couldn't detect it automatically");
            this.pipeline().fireExceptionCaught((Throwable)new PcapException("Network device not specified and couldn't detect it automatically"));
            return;
        }
        PcapNetworkInterface nif = Pcaps.getDevByName((String)deviceName);
        this.handle = nif.openLive(65535, PcapNetworkInterface.PromiscuousMode.PROMISCUOUS, 10);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Listening on device %s", deviceName));
        }
        if ((filter = this.config.getFilterString(localAddress, remoteAddress)).length() > 0) {
            this.handle.setFilter(filter, BpfProgram.BpfCompileMode.OPTIMIZE);
        }
        final ByteBuf buffer = Unpooled.buffer();
        this.loopThread = new Thread(() -> {
            try {
                this.handle.loop(-1, new PacketListener(){

                    public void gotPacket(Packet packet) {
                        buffer.writeBytes(RawSocketChannel.this.config.getPacketHandler().getData(packet));
                    }
                });
            }
            catch (NotOpenException | PcapNativeException e) {
                logger.error("Pcap4j loop thread died!", e);
                this.pipeline().fireExceptionCaught(e);
            }
            catch (InterruptedException e) {
                logger.warn("PCAP Loop Thread was interrupted (hopefully intentionally)", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
        this.loopThread.start();
        this.activate(new PcapInputStream(buffer), new DiscardingOutputStream());
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected SocketAddress remoteAddress0() {
        return this.remoteRawSocketAddress;
    }

    protected void doBind(SocketAddress localAddress) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void doDisconnect() {
        this.loopThread.interrupt();
        if (this.handle != null) {
            this.handle.close();
        }
    }

    protected int doReadBytes(ByteBuf buf) throws Exception {
        if (this.handle == null || !this.handle.isOpen()) {
            return -1;
        }
        try {
            return super.doReadBytes(buf);
        }
        catch (SocketTimeoutException ignored) {
            return 0;
        }
    }

    public ChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return true;
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new RawSocketUnsafe();
    }

    private String getDeviceName(RawSocketAddress rawSocketAddress) {
        if (rawSocketAddress.getDeviceName() != null) {
            return rawSocketAddress.getDeviceName();
        }
        return null;
    }

    private class RawSocketUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private RawSocketUnsafe() {
            super((AbstractChannel)RawSocketChannel.this);
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            try {
                RawSocketChannel.this.doConnect(remoteAddress, localAddress);
                RawSocketChannel.this.pipeline().fireChannelActive();
                promise.setSuccess();
            }
            catch (Exception e) {
                promise.setFailure((Throwable)e);
            }
        }
    }

    private static class PcapInputStream
    extends InputStream {
        final ByteBuf buf;

        private PcapInputStream(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public int available() {
            return this.buf.readableBytes();
        }

        @Override
        public int read() throws IOException {
            long timeout = System.nanoTime() + 10000L;
            while (System.nanoTime() < timeout) {
                if (this.buf.readableBytes() <= 0) continue;
                return this.buf.readByte() & 0xFF;
            }
            throw new SocketTimeoutException();
        }
    }

    private static class DiscardingOutputStream
    extends OutputStream {
        private DiscardingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            logger.debug("Discarding {}", (Object)b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            logger.debug("Discarding {}", (Object)b);
        }
    }
}

