/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import org.apache.rat.report.IReportable;

public abstract class Walker
implements IReportable {
    protected final File file;
    protected final String name;
    protected final FilenameFilter filter;

    protected static FilenameFilter regexFilter(final Pattern pattern) {
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean result = pattern == null ? true : !pattern.matcher(name).matches();
                return result;
            }
        };
    }

    protected boolean isRestricted(File file) {
        return file.getName().startsWith(".");
    }

    protected final boolean ignored(File file) {
        boolean result = false;
        if (this.filter != null) {
            String name = file.getName();
            File dir = file.getParentFile();
            result = !this.filter.accept(dir, name);
        }
        return result;
    }

    public Walker(File file, FilenameFilter filter) {
        this(file.getPath(), file, filter);
    }

    protected Walker(String name, File file, FilenameFilter filter) {
        this.name = name;
        this.file = file;
        this.filter = filter;
    }
}

