/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import io.protostuff.compiler.model.Enum;
import io.protostuff.compiler.model.EnumConstant;
import io.protostuff.compiler.model.Field;
import io.protostuff.compiler.model.Import;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.protostuff.compiler.model.Service;
import io.protostuff.compiler.model.ServiceMethod;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;

public class ProtoToStringGenerator {
    private final Proto proto;

    public ProtoToStringGenerator(Proto proto) {
        this.proto = proto;
    }

    public String protoToString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"syntax = \"%s\";", (Object[])new Object[]{this.proto.getSyntax()});
        for (Import importValue : this.proto.getImports()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"import \"%s\";", (Object[])new Object[]{importValue.getValue()});
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"package %s;\n", (Object[])new Object[]{this.proto.getPackage().getValue()});
        for (Message message : this.proto.getMessages()) {
            this.messageToString(message, sb);
        }
        for (Enum enumValue : this.proto.getEnums()) {
            this.enumToString(enumValue, sb);
        }
        for (Service service : this.proto.getServices()) {
            this.serviceToString(service, sb);
        }
        return sb.toString();
    }

    private void serviceToString(Service service, StringBuilder sb) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"service %s {", (Object[])new Object[]{service.getName()});
        for (ServiceMethod serviceMethod : service.getMethods()) {
            if (!serviceMethod.getCommentLines().isEmpty()) {
                StringBuilderUtils.appendLine((StringBuilder)sb, (String)("  //" + serviceMethod.getComments()), (Object[])new Object[0]);
            }
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  rpc %s (%s) returns (%s);\n", (Object[])new Object[]{serviceMethod.getName(), serviceMethod.getArgTypeName(), serviceMethod.getReturnTypeName()});
        }
        if (!service.getMethods().isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"}", (Object[])new Object[0]);
    }

    protected void enumToString(Enum enumValue, StringBuilder sb) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"enum %s {", (Object[])new Object[]{enumValue.getName()});
        for (EnumConstant enumConstant : enumValue.getConstants()) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  %s = %s;", (Object[])new Object[]{enumConstant.getName(), enumConstant.getValue()});
        }
        sb.append("}\n\n");
    }

    private void messageToString(Message message, StringBuilder sb) {
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"message %s {", (Object[])new Object[]{message.getName()});
        for (Field field : message.getFields()) {
            sb.append("  ");
            this.fieldToString(field, field.isRepeated(), sb);
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"}\n", (Object[])new Object[0]);
    }

    private void fieldToString(Field field, boolean repeated, StringBuilder sb) {
        if (field.isMap()) {
            this.fieldMapToString(field, sb);
            return;
        }
        if (repeated) {
            this.fieldRepeatedToString(field, sb);
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"%s %s = %d;", (Object[])new Object[]{field.getTypeName(), field.getName(), field.getTag()});
    }

    private void fieldRepeatedToString(Field field, StringBuilder sb) {
        sb.append("repeated ");
        this.fieldToString(field, false, sb);
    }

    private void fieldMapToString(Field field, StringBuilder sb) {
        Message entryMessage = (Message)field.getType();
        Field keyField = entryMessage.getField(1);
        Field valueField = entryMessage.getField(2);
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"map<%s, %s> %s = %d;", (Object[])new Object[]{keyField.getTypeName(), valueField.getTypeName(), field.getName(), field.getTag()});
    }
}

