/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.lifecycle.internal.operate;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.shardingsphere.elasticjob.infra.handler.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.infra.yaml.YamlEngine;
import org.apache.shardingsphere.elasticjob.lite.internal.server.ServerStatus;
import org.apache.shardingsphere.elasticjob.lite.internal.storage.JobNodePath;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobOperateAPI;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class JobOperateAPIImpl
implements JobOperateAPI {
    private final CoordinatorRegistryCenter regCenter;

    public JobOperateAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    @Override
    public void trigger(String jobName) {
        Preconditions.checkNotNull((Object)jobName, (Object)"Job name cannot be null");
        JobNodePath jobNodePath = new JobNodePath(jobName);
        for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
            this.regCenter.persist(jobNodePath.getInstanceNodePath(each), "TRIGGER");
        }
    }

    @Override
    public void disable(String jobName, String serverIp) {
        this.disableOrEnableJobs(jobName, serverIp, true);
    }

    @Override
    public void enable(String jobName, String serverIp) {
        this.disableOrEnableJobs(jobName, serverIp, false);
    }

    private void disableOrEnableJobs(String jobName, String serverIp, boolean disabled) {
        Preconditions.checkArgument((null != jobName || null != serverIp ? 1 : 0) != 0, (Object)"At least indicate jobName or serverIp.");
        if (null != jobName && null != serverIp) {
            this.persistDisabledOrEnabledJob(jobName, serverIp, disabled);
        } else if (null != jobName) {
            JobNodePath jobNodePath = new JobNodePath(jobName);
            for (String each : this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath())) {
                if (disabled) {
                    this.regCenter.persist(jobNodePath.getServerNodePath(each), ServerStatus.DISABLED.name());
                    continue;
                }
                this.regCenter.persist(jobNodePath.getServerNodePath(each), ServerStatus.ENABLED.name());
            }
        } else {
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String each : jobNames) {
                if (!this.regCenter.isExisted(new JobNodePath(each).getServerNodePath(serverIp))) continue;
                this.persistDisabledOrEnabledJob(each, serverIp, disabled);
            }
        }
    }

    private void persistDisabledOrEnabledJob(String jobName, String serverIp, boolean disabled) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String serverNodePath = jobNodePath.getServerNodePath(serverIp);
        if (disabled) {
            this.regCenter.persist(serverNodePath, ServerStatus.DISABLED.name());
        } else {
            this.regCenter.persist(serverNodePath, ServerStatus.ENABLED.name());
        }
    }

    @Override
    public void shutdown(String jobName, String serverIp) {
        Preconditions.checkArgument((null != jobName || null != serverIp ? 1 : 0) != 0, (Object)"At least indicate jobName or serverIp.");
        if (null != jobName && null != serverIp) {
            JobNodePath jobNodePath = new JobNodePath(jobName);
            for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
                JobInstance jobInstance = (JobInstance)YamlEngine.unmarshal((String)this.regCenter.get(jobNodePath.getInstanceNodePath(each)), JobInstance.class);
                if (!serverIp.equals(jobInstance.getServerIp())) continue;
                this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
            }
        } else if (null != jobName) {
            JobNodePath jobNodePath = new JobNodePath(jobName);
            for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
                this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
            }
        } else {
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String job : jobNames) {
                JobNodePath jobNodePath = new JobNodePath(job);
                List instances = this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath());
                for (String each : instances) {
                    JobInstance jobInstance = (JobInstance)YamlEngine.unmarshal((String)this.regCenter.get(jobNodePath.getInstanceNodePath(each)), JobInstance.class);
                    if (!serverIp.equals(jobInstance.getServerIp())) continue;
                    this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
                }
            }
        }
    }

    @Override
    public void remove(String jobName, String serverIp) {
        block3: {
            block4: {
                block2: {
                    this.shutdown(jobName, serverIp);
                    if (null == jobName || null == serverIp) break block2;
                    this.regCenter.remove(new JobNodePath(jobName).getServerNodePath(serverIp));
                    break block3;
                }
                if (null == jobName) break block4;
                JobNodePath jobNodePath = new JobNodePath(jobName);
                List servers = this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath());
                for (String each : servers) {
                    this.regCenter.remove(jobNodePath.getServerNodePath(each));
                }
                break block3;
            }
            if (null == serverIp) break block3;
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String each : jobNames) {
                this.regCenter.remove(new JobNodePath(each).getServerNodePath(serverIp));
            }
        }
    }
}

