/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.condition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptEqualCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.SimpleExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateBetweenRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateCompareRightValue;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.value.PredicateInRightValue;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class EncryptConditionEngine {
    private final EncryptRule encryptRule;
    private final SchemaMetaData schemaMetaData;

    public List<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext) {
        if (!(sqlStatementContext instanceof WhereAvailable)) {
            return Collections.emptyList();
        }
        Optional whereSegment = ((WhereAvailable)sqlStatementContext).getWhere();
        if (!whereSegment.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        for (AndPredicate each : ((WhereSegment)whereSegment.get()).getAndPredicates()) {
            result.addAll(this.createEncryptConditions(sqlStatementContext, each));
        }
        return result;
    }

    private Collection<EncryptCondition> createEncryptConditions(SQLStatementContext sqlStatementContext, AndPredicate andPredicate) {
        LinkedList<EncryptCondition> result = new LinkedList<EncryptCondition>();
        HashSet<Integer> stopIndexes = new HashSet<Integer>();
        for (PredicateSegment predicate : andPredicate.getPredicates()) {
            if (!stopIndexes.add(predicate.getStopIndex())) continue;
            this.createEncryptCondition(sqlStatementContext, predicate).ifPresent(result::add);
        }
        return result;
    }

    private Optional<EncryptCondition> createEncryptCondition(SQLStatementContext sqlStatementContext, PredicateSegment predicateSegment) {
        Optional tableName = sqlStatementContext.getTablesContext().findTableName(predicateSegment.getColumn(), this.schemaMetaData);
        return tableName.isPresent() && this.encryptRule.findEncryptor((String)tableName.get(), predicateSegment.getColumn().getIdentifier().getValue()).isPresent() ? this.createEncryptCondition(predicateSegment, (String)tableName.get()) : Optional.empty();
    }

    private Optional<EncryptCondition> createEncryptCondition(PredicateSegment predicateSegment, String tableName) {
        if (predicateSegment.getRightValue() instanceof PredicateCompareRightValue) {
            PredicateCompareRightValue compareRightValue = (PredicateCompareRightValue)predicateSegment.getRightValue();
            return this.isSupportedOperator(compareRightValue.getOperator()) ? EncryptConditionEngine.createCompareEncryptCondition(tableName, predicateSegment, compareRightValue) : Optional.empty();
        }
        if (predicateSegment.getRightValue() instanceof PredicateInRightValue) {
            return EncryptConditionEngine.createInEncryptCondition(tableName, predicateSegment, (PredicateInRightValue)predicateSegment.getRightValue());
        }
        if (predicateSegment.getRightValue() instanceof PredicateBetweenRightValue) {
            throw new ShardingSphereException("The SQL clause 'BETWEEN...AND...' is unsupported in encrypt rule.", new Object[0]);
        }
        return Optional.empty();
    }

    private static Optional<EncryptCondition> createCompareEncryptCondition(String tableName, PredicateSegment predicateSegment, PredicateCompareRightValue compareRightValue) {
        return compareRightValue.getExpression() instanceof SimpleExpressionSegment ? Optional.of(new EncryptEqualCondition(predicateSegment.getColumn().getIdentifier().getValue(), tableName, compareRightValue.getExpression().getStartIndex(), predicateSegment.getStopIndex(), compareRightValue.getExpression())) : Optional.empty();
    }

    private static Optional<EncryptCondition> createInEncryptCondition(String tableName, PredicateSegment predicateSegment, PredicateInRightValue inRightValue) {
        LinkedList<ExpressionSegment> expressionSegments = new LinkedList<ExpressionSegment>();
        for (ExpressionSegment each : inRightValue.getSqlExpressions()) {
            if (!(each instanceof SimpleExpressionSegment)) continue;
            expressionSegments.add(each);
        }
        return expressionSegments.isEmpty() ? Optional.empty() : Optional.of(new EncryptInCondition(predicateSegment.getColumn().getIdentifier().getValue(), tableName, inRightValue.getPredicateBracketValue().getPredicateLeftBracketValue().getStartIndex(), predicateSegment.getStopIndex(), expressionSegments));
    }

    private boolean isSupportedOperator(String operator) {
        return "=".equals(operator) || "<>".equals(operator) || "!=".equals(operator);
    }

    @Generated
    public EncryptConditionEngine(EncryptRule encryptRule, SchemaMetaData schemaMetaData) {
        this.encryptRule = encryptRule;
        this.schemaMetaData = schemaMetaData;
    }
}

