/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.underlying.rewrite.parameter.builder.impl.GroupedParameterBuilder;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
extends EncryptParameterRewriter<InsertStatementContext>
implements QueryWithCipherColumnAware {
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getOnDuplicateKeyColumns().isPresent();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Preconditions.checkState((boolean)((InsertStatement)insertStatementContext.getSqlStatement()).getOnDuplicateKeyColumns().isPresent());
        OnDuplicateKeyColumnsSegment onDuplicateKeyColumnsSegment = (OnDuplicateKeyColumnsSegment)((InsertStatement)insertStatementContext.getSqlStatement()).getOnDuplicateKeyColumns().get();
        Collection onDuplicateKeyColumnsSegments = onDuplicateKeyColumnsSegment.getColumns();
        if (onDuplicateKeyColumnsSegments.isEmpty()) {
            return;
        }
        GroupedParameterBuilder groupedParameterBuilder = (GroupedParameterBuilder)parameterBuilder;
        for (AssignmentSegment each : onDuplicateKeyColumnsSegments) {
            Optional encryptor;
            ExpressionSegment expressionSegment = each.getValue();
            Object plainColumnValue = null;
            if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                plainColumnValue = parameters.get(((ParameterMarkerExpressionSegment)expressionSegment).getParameterMarkerIndex());
            }
            if (this.queryWithCipherColumn && (encryptor = this.getEncryptRule().findEncryptor(tableName, each.getColumn().getIdentifier().getValue())).isPresent()) {
                String cipherColumnValue = ((Encryptor)encryptor.get()).encrypt(plainColumnValue);
                groupedParameterBuilder.getOnDuplicateKeyUpdateAddedParameters().add(cipherColumnValue);
            }
            if (null == plainColumnValue) continue;
            groupedParameterBuilder.getOnDuplicateKeyUpdateAddedParameters().add(plainColumnValue);
        }
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

