/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.AssistQueryAndPlainInsertColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptForUseDefaultInsertColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptInsertOnUpdateTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptInsertValuesTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptPredicateRightValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.EncryptProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.impl.InsertCipherNameTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.SQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.builder.SQLTokenGeneratorBuilder;

public final class EncryptTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final EncryptRule encryptRule;
    private final boolean queryWithCipherColumn;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        Collection<SQLTokenGenerator> result = this.buildSQLTokenGenerators();
        for (SQLTokenGenerator each : result) {
            if (each instanceof EncryptRuleAware) {
                ((EncryptRuleAware)each).setEncryptRule(this.encryptRule);
            }
            if (!(each instanceof QueryWithCipherColumnAware)) continue;
            ((QueryWithCipherColumnAware)each).setQueryWithCipherColumn(this.queryWithCipherColumn);
        }
        return result;
    }

    private Collection<SQLTokenGenerator> buildSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        result.add(new EncryptProjectionTokenGenerator());
        result.add(new EncryptAssignmentTokenGenerator());
        result.add(new EncryptPredicateColumnTokenGenerator());
        result.add(new EncryptPredicateRightValueTokenGenerator());
        result.add(new EncryptInsertValuesTokenGenerator());
        result.add(new EncryptForUseDefaultInsertColumnsTokenGenerator());
        result.add(new InsertCipherNameTokenGenerator());
        result.add(new AssistQueryAndPlainInsertColumnsTokenGenerator());
        result.add(new EncryptInsertOnUpdateTokenGenerator());
        return result;
    }

    @Generated
    public EncryptTokenGenerateBuilder(EncryptRule encryptRule, boolean queryWithCipherColumn) {
        this.encryptRule = encryptRule;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

