/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.strategy.EncryptTable;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;

public final class EncryptPredicateColumnTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
QueryWithCipherColumnAware {
    private SchemaMetaData schemaMetaData;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkState((boolean)((WhereAvailable)sqlStatementContext).getWhere().isPresent());
        LinkedHashSet<SubstitutableColumnNameToken> result = new LinkedHashSet<SubstitutableColumnNameToken>();
        for (AndPredicate each : ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getAndPredicates()) {
            result.addAll(this.generateSQLTokens(sqlStatementContext, each));
        }
        return result;
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext, AndPredicate andPredicate) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (PredicateSegment each : andPredicate.getPredicates()) {
            Optional plainColumn;
            Optional<EncryptTable> encryptTable = this.findEncryptTable(sqlStatementContext, each);
            if (!encryptTable.isPresent() || !encryptTable.get().findEncryptor(each.getColumn().getIdentifier().getValue()).isPresent()) continue;
            int startIndex = each.getColumn().getOwner().isPresent() ? ((OwnerSegment)each.getColumn().getOwner().get()).getStopIndex() + 2 : each.getColumn().getStartIndex();
            int stopIndex = each.getColumn().getStopIndex();
            if (!this.queryWithCipherColumn && (plainColumn = encryptTable.get().findPlainColumn(each.getColumn().getIdentifier().getValue())).isPresent()) {
                result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, (String)plainColumn.get()));
                continue;
            }
            Optional assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(each.getColumn().getIdentifier().getValue());
            SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(columnName -> new SubstitutableColumnNameToken(startIndex, stopIndex, columnName)).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, ((EncryptTable)encryptTable.get()).getCipherColumn(each.getColumn().getIdentifier().getValue())));
            result.add(encryptColumnNameToken);
        }
        return result;
    }

    private Optional<EncryptTable> findEncryptTable(SQLStatementContext sqlStatementContext, PredicateSegment segment) {
        return sqlStatementContext.getTablesContext().findTableName(segment.getColumn(), this.schemaMetaData).flatMap(tableName -> this.getEncryptRule().findEncryptTable(tableName));
    }

    @Generated
    public void setSchemaMetaData(SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

