/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptConditionEngine;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptInCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateEqualRightValueToken;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptPredicateInRightValueToken;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.ParametersAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;

public final class EncryptPredicateRightValueTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
ParametersAware,
QueryWithCipherColumnAware {
    private SchemaMetaData schemaMetaData;
    private List<Object> parameters;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        List<EncryptCondition> encryptConditions = new EncryptConditionEngine(this.getEncryptRule(), this.schemaMetaData).createEncryptConditions(sqlStatementContext);
        return encryptConditions.isEmpty() ? Collections.emptyList() : this.generateSQLTokens(encryptConditions);
    }

    private Collection<SQLToken> generateSQLTokens(List<EncryptCondition> encryptConditions) {
        LinkedHashSet<SQLToken> result = new LinkedHashSet<SQLToken>();
        for (EncryptCondition each : encryptConditions) {
            result.add(this.generateSQLToken(each));
        }
        return result;
    }

    private SQLToken generateSQLToken(EncryptCondition encryptCondition) {
        List<Object> originalValues = encryptCondition.getValues(this.parameters);
        int startIndex = encryptCondition.getStartIndex();
        return this.queryWithCipherColumn ? this.generateSQLTokenForQueryWithCipherColumn(encryptCondition, originalValues, startIndex) : this.generateSQLTokenForQueryWithoutCipherColumn(encryptCondition, originalValues, startIndex);
    }

    private SQLToken generateSQLTokenForQueryWithCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), this.getEncryptedValues(encryptCondition, originalValues));
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private List<Object> getEncryptedValues(EncryptCondition encryptCondition, List<Object> originalValues) {
        Optional assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(encryptCondition.getTableName(), encryptCondition.getColumnName());
        return assistedQueryColumn.isPresent() ? this.getEncryptRule().getEncryptAssistedQueryValues(encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues) : this.getEncryptRule().getEncryptValues(encryptCondition.getTableName(), encryptCondition.getColumnName(), originalValues);
    }

    private SQLToken generateSQLTokenForQueryWithoutCipherColumn(EncryptCondition encryptCondition, List<Object> originalValues, int startIndex) {
        int stopIndex = encryptCondition.getStopIndex();
        Map<Integer, Object> indexValues = this.getPositionValues(encryptCondition.getPositionValueMap().keySet(), originalValues);
        Set<Integer> parameterMarkerIndexes = encryptCondition.getPositionIndexMap().keySet();
        return encryptCondition instanceof EncryptInCondition ? new EncryptPredicateInRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes) : new EncryptPredicateEqualRightValueToken(startIndex, stopIndex, indexValues, parameterMarkerIndexes);
    }

    private Map<Integer, Object> getPositionValues(Collection<Integer> valuePositions, List<Object> encryptValues) {
        LinkedHashMap<Integer, Object> result = new LinkedHashMap<Integer, Object>();
        for (int each : valuePositions) {
            result.put(each, encryptValues.get(each));
        }
        return result;
    }

    @Generated
    public void setSchemaMetaData(SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
    }

    @Generated
    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

