/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.strategy.EncryptTable;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;

public final class EncryptProjectionTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext>,
QueryWithCipherColumnAware {
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatement)((SelectStatementContext)sqlStatementContext).getSqlStatement()).getSimpleTableSegments().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SelectStatementContext selectStatementContext) {
        ProjectionsSegment projectionsSegment = ((SelectStatement)selectStatementContext.getSqlStatement()).getProjections();
        String tableName = ((SimpleTableSegment)((SelectStatement)selectStatementContext.getSqlStatement()).getSimpleTableSegments().iterator().next()).getTableName().getIdentifier().getValue();
        return this.getEncryptRule().findEncryptTable(tableName).map(encryptTable -> this.generateSQLTokens(projectionsSegment, tableName, selectStatementContext, (EncryptTable)encryptTable)).orElseGet(Collections::emptyList);
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(ProjectionsSegment segment, String tableName, SelectStatementContext selectStatementContext, EncryptTable encryptTable) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ProjectionSegment each : segment.getProjections()) {
            if (each instanceof ColumnProjectionSegment && encryptTable.getLogicColumns().contains(((ColumnProjectionSegment)each).getColumn().getIdentifier().getValue())) {
                result.add(this.generateSQLToken((ColumnProjectionSegment)each, tableName));
            }
            if (!(each instanceof ShorthandProjectionSegment)) continue;
            result.add(this.generateSQLToken((ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext(), tableName, encryptTable));
        }
        return result;
    }

    private SubstitutableColumnNameToken generateSQLToken(ColumnProjectionSegment segment, String tableName) {
        String encryptColumnName = this.getEncryptColumnName(tableName, segment.getColumn().getIdentifier().getValue());
        if (!segment.getAlias().isPresent()) {
            encryptColumnName = encryptColumnName + " AS " + segment.getColumn().getIdentifier().getValue();
        }
        return segment.getColumn().getOwner().isPresent() ? new SubstitutableColumnNameToken(((OwnerSegment)segment.getColumn().getOwner().get()).getStopIndex() + 2, segment.getStopIndex(), encryptColumnName) : new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), encryptColumnName);
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext, String tableName, EncryptTable encryptTable) {
        ShorthandProjection shorthandProjection = this.getShorthandProjection(segment, projectionsContext);
        LinkedList<String> shorthandExtensionProjections = new LinkedList<String>();
        for (ColumnProjection each : shorthandProjection.getActualColumns()) {
            if (encryptTable.getLogicColumns().contains(each.getName())) {
                shorthandExtensionProjections.add(new ColumnProjection(each.getOwner(), this.getEncryptColumnName(tableName, each.getName()), each.getName()).getExpressionWithAlias());
                continue;
            }
            shorthandExtensionProjections.add(each.getExpression());
        }
        return new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), Joiner.on((String)", ").join(shorthandExtensionProjections));
    }

    private String getEncryptColumnName(String tableName, String logicEncryptColumnName) {
        Optional plainColumn = this.getEncryptRule().findPlainColumn(tableName, logicEncryptColumnName);
        return plainColumn.isPresent() && !this.queryWithCipherColumn ? (String)plainColumn.get() : this.getEncryptRule().getCipherColumn(tableName, logicEncryptColumnName);
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is: `%s`", owner.orElse(null)));
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

