/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.judgement.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.core.rule.ShadowRule;
import org.apache.shardingsphere.shadow.rewrite.condition.ShadowCondition;
import org.apache.shardingsphere.shadow.rewrite.condition.ShadowConditionEngine;
import org.apache.shardingsphere.shadow.rewrite.judgement.ShadowJudgementEngine;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;

public final class SimpleJudgementEngine
implements ShadowJudgementEngine {
    private final ShadowRule shadowRule;
    private final SQLStatementContext sqlStatementContext;

    @Override
    public boolean isShadowSQL() {
        if (this.sqlStatementContext instanceof InsertStatementContext) {
            for (InsertValueContext each : ((InsertStatementContext)this.sqlStatementContext).getInsertValueContexts()) {
                if (!this.judgeShadowSqlForInsert(each, (InsertStatementContext)this.sqlStatementContext)) continue;
                return true;
            }
            return false;
        }
        if (this.sqlStatementContext instanceof WhereAvailable) {
            Optional<ShadowCondition> shadowCondition = new ShadowConditionEngine(this.shadowRule).createShadowCondition(this.sqlStatementContext);
            if (!shadowCondition.isPresent()) {
                return false;
            }
            List<Object> values = shadowCondition.get().getValues(Collections.emptyList());
            return values.size() != 0 && "TRUE".equals(String.valueOf(values.get(0)).toUpperCase());
        }
        return false;
    }

    private boolean judgeShadowSqlForInsert(InsertValueContext insertValueContext, InsertStatementContext insertStatementContext) {
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            if (!this.shadowRule.getColumn().equals(columnName)) continue;
            int columnIndex = insertStatementContext.getColumnNames().indexOf(columnName);
            Object value = insertValueContext.getValue(columnIndex);
            return "TRUE".equals(String.valueOf(value).toUpperCase());
        }
        return false;
    }

    @Generated
    public SimpleJudgementEngine(ShadowRule shadowRule, SQLStatementContext sqlStatementContext) {
        this.shadowRule = shadowRule;
        this.sqlStatementContext = sqlStatementContext;
    }
}

