/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Iterator;
import org.apache.shardingsphere.shadow.rewrite.token.generator.BaseShadowSQLTokenGenerator;
import org.apache.shardingsphere.shadow.rewrite.token.pojo.ShadowInsertValuesToken;
import org.apache.shardingsphere.sql.parser.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.OptionalSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValue;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.InsertValuesToken;

public final class ShadowInsertValuesTokenGenerator
extends BaseShadowSQLTokenGenerator
implements OptionalSQLTokenGenerator<InsertStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForShadow(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && ((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement()).getColumnNames().contains(this.getShadowRule().getColumn());
    }

    public InsertValuesToken generateSQLToken(InsertStatementContext insertStatementContext) {
        Collection insertValuesSegments = ((InsertStatement)insertStatementContext.getSqlStatement()).getValues();
        ShadowInsertValuesToken result = new ShadowInsertValuesToken(this.getStartIndex(insertValuesSegments), this.getStopIndex(insertValuesSegments));
        for (InsertValueContext each : insertStatementContext.getInsertValueContexts()) {
            InsertValue insertValueToken = new InsertValue(each.getValueExpressions());
            Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
            while (descendingColumnNames.hasNext()) {
                String columnName = (String)descendingColumnNames.next();
                if (!this.getShadowRule().getColumn().equals(columnName)) continue;
                this.removeValueToken(insertValueToken, insertStatementContext, columnName);
            }
            result.getInsertValues().add(insertValueToken);
        }
        return result;
    }

    private void removeValueToken(InsertValue insertValueToken, InsertStatementContext insertStatementContext, String columnName) {
        int columnIndex = insertStatementContext.getColumnNames().indexOf(columnName);
        insertValueToken.getValues().remove(columnIndex);
    }

    private int getStartIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStartIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.min(result, each.getStartIndex());
        }
        return result;
    }

    private int getStopIndex(Collection<InsertValuesSegment> segments) {
        int result = segments.iterator().next().getStopIndex();
        for (InsertValuesSegment each : segments) {
            result = Math.max(result, each.getStopIndex());
        }
        return result;
    }
}

