/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rewrite.token.generator.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.shardingsphere.shadow.rewrite.token.generator.BaseShadowSQLTokenGenerator;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.PredicateSegment;
import org.apache.shardingsphere.sql.parser.sql.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.underlying.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.underlying.rewrite.sql.token.pojo.generic.RemoveToken;

public final class ShadowPredicateColumnTokenGenerator
extends BaseShadowSQLTokenGenerator
implements CollectionSQLTokenGenerator {
    @Override
    protected boolean isGenerateSQLTokenForShadow(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent();
    }

    public Collection<SQLToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Preconditions.checkState((boolean)((WhereAvailable)sqlStatementContext).getWhere().isPresent());
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AndPredicate each : ((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get()).getAndPredicates()) {
            result.addAll(this.generateSQLTokens((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get(), each));
        }
        return result;
    }

    private Collection<SQLToken> generateSQLTokens(WhereSegment whereSegment, AndPredicate andPredicate) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        LinkedList predicates = (LinkedList)andPredicate.getPredicates();
        for (int i = 0; i < predicates.size(); ++i) {
            if (!this.getShadowRule().getColumn().equals(((PredicateSegment)predicates.get(i)).getColumn().getIdentifier().getValue())) continue;
            if (1 == predicates.size()) {
                int startIndex = whereSegment.getStartIndex();
                int stopIndex = whereSegment.getStopIndex();
                result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
                return result;
            }
            if (i == 0) {
                int startIndex = ((PredicateSegment)predicates.get(i)).getStartIndex();
                int stopIndex = ((PredicateSegment)predicates.get(i + 1)).getStartIndex() - 1;
                result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
                return result;
            }
            int startIndex = ((PredicateSegment)predicates.get(i - 1)).getStopIndex() + 1;
            int stopIndex = ((PredicateSegment)predicates.get(i)).getStopIndex();
            result.add((SQLToken)new RemoveToken(startIndex, stopIndex));
            return result;
        }
        return result;
    }
}

