/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.extractor;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.ddl.column.ColumnDefinitionExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;

public final class OracleModifyColumnDefinitionExtractor
implements CollectionSQLSegmentExtractor {
    private final ColumnDefinitionExtractor columnDefinitionPhraseExtractor = new ColumnDefinitionExtractor();

    public Collection<ModifyColumnDefinitionSegment> extract(ParserRuleContext ancestorNode) {
        Collection modifyColumnNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)ancestorNode, (RuleName)RuleName.MODIFY_COLUMN_SPECIFICATION);
        if (modifyColumnNodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ModifyColumnDefinitionSegment> result = new LinkedList<ModifyColumnDefinitionSegment>();
        for (ParserRuleContext modifyColumnNode : modifyColumnNodes) {
            for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes((ParserRuleContext)modifyColumnNode, (RuleName)RuleName.MODIFY_COL_PROPERTIES)) {
                Optional columnDefinition = this.columnDefinitionPhraseExtractor.extract(each);
                if (!columnDefinition.isPresent()) continue;
                result.add(new ModifyColumnDefinitionSegment(null, (ColumnDefinitionSegment)columnDefinition.get()));
            }
        }
        return result;
    }
}

