/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.yaml.config.masterslave.YamlRootMasterSlaveConfiguration;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.core.yaml.swapper.impl.MasterSlaveRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.MasterSlaveDataSourceFactory;

public final class YamlMasterSlaveDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlRootMasterSlaveConfiguration config = (YamlRootMasterSlaveConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootMasterSlaveConfiguration.class);
        return MasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), new MasterSlaveRuleConfigurationYamlSwapper().swap(config.getMasterSlaveRule()), config.getProps());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlRootMasterSlaveConfiguration config = (YamlRootMasterSlaveConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootMasterSlaveConfiguration.class);
        return MasterSlaveDataSourceFactory.createDataSource(config.getDataSources(), new MasterSlaveRuleConfigurationYamlSwapper().swap(config.getMasterSlaveRule()), config.getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlRootMasterSlaveConfiguration config = (YamlRootMasterSlaveConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootMasterSlaveConfiguration.class);
        return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, new MasterSlaveRuleConfigurationYamlSwapper().swap(config.getMasterSlaveRule()), config.getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlRootMasterSlaveConfiguration config = (YamlRootMasterSlaveConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootMasterSlaveConfiguration.class);
        return MasterSlaveDataSourceFactory.createDataSource(dataSourceMap, new MasterSlaveRuleConfigurationYamlSwapper().swap(config.getMasterSlaveRule()), config.getProps());
    }

    private YamlMasterSlaveDataSourceFactory() {
    }
}

