/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.executor;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.execute.ShardingExecuteEngine;
import org.apache.shardingsphere.core.execute.ShardingExecuteGroup;
import org.apache.shardingsphere.core.execute.StatementExecuteUnit;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataConnectionManager;
import org.apache.shardingsphere.core.execute.metadata.TableMetaDataInitializer;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteTemplate;
import org.apache.shardingsphere.core.execute.sql.prepare.SQLExecutePrepareTemplate;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import org.apache.shardingsphere.shardingjdbc.jdbc.metadata.JDBCTableMetaDataConnectionManager;

public class AbstractStatementExecutor {
    private final DatabaseType databaseType;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final ShardingConnection connection;
    private final SQLExecutePrepareTemplate sqlExecutePrepareTemplate;
    private final SQLExecuteTemplate sqlExecuteTemplate;
    private final Collection<Connection> connections = new LinkedList<Connection>();
    private SQLStatement sqlStatement;
    private final List<List<Object>> parameterSets = new LinkedList<List<Object>>();
    private final List<Statement> statements = new LinkedList<Statement>();
    private final List<ResultSet> resultSets = new CopyOnWriteArrayList<ResultSet>();
    private final Collection<ShardingExecuteGroup<StatementExecuteUnit>> executeGroups = new LinkedList<ShardingExecuteGroup<StatementExecuteUnit>>();

    public AbstractStatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, ShardingConnection shardingConnection) {
        this.databaseType = shardingConnection.getShardingContext().getDatabaseType();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.connection = shardingConnection;
        int maxConnectionsSizePerQuery = (Integer)this.connection.getShardingContext().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        ShardingExecuteEngine executeEngine = this.connection.getShardingContext().getExecuteEngine();
        this.sqlExecutePrepareTemplate = new SQLExecutePrepareTemplate(maxConnectionsSizePerQuery);
        this.sqlExecuteTemplate = new SQLExecuteTemplate(executeEngine, this.connection.isSerialExecute());
    }

    protected final void cacheStatements() {
        for (ShardingExecuteGroup<StatementExecuteUnit> each : this.executeGroups) {
            this.statements.addAll(Lists.transform((List)each.getInputs(), (Function)new Function<StatementExecuteUnit, Statement>(){

                public Statement apply(StatementExecuteUnit input) {
                    return input.getStatement();
                }
            }));
            this.parameterSets.addAll(Lists.transform((List)each.getInputs(), (Function)new Function<StatementExecuteUnit, List<Object>>(){

                public List<Object> apply(StatementExecuteUnit input) {
                    return input.getRouteUnit().getSqlUnit().getParameters();
                }
            }));
        }
    }

    protected final <T> List<T> executeCallback(SQLExecuteCallback<T> executeCallback) throws SQLException {
        List result = this.sqlExecuteTemplate.executeGroup(this.executeGroups, executeCallback);
        this.refreshShardingMetaDataIfNeeded(this.connection.getShardingContext(), this.sqlStatement);
        return result;
    }

    protected boolean isAccumulate() {
        return !this.connection.getShardingContext().getShardingRule().isAllBroadcastTables(this.sqlStatement.getTables().getTableNames());
    }

    public void clear() throws SQLException {
        this.clearStatements();
        this.statements.clear();
        this.parameterSets.clear();
        this.connections.clear();
        this.resultSets.clear();
        this.executeGroups.clear();
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.getStatements()) {
            each.close();
        }
    }

    private void refreshShardingMetaDataIfNeeded(ShardingContext shardingContext, SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.refreshTableMetaData(shardingContext, (CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.refreshTableMetaData(shardingContext, (AlterTableStatement)sqlStatement);
        } else if (sqlStatement instanceof DropTableStatement) {
            this.refreshTableMetaData(shardingContext, (DropTableStatement)sqlStatement);
        }
    }

    private void refreshTableMetaData(ShardingContext shardingContext, CreateTableStatement createTableStatement) {
        String tableName = createTableStatement.getTables().getSingleTableName();
        shardingContext.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer().load(tableName, shardingContext.getShardingRule()));
    }

    private void refreshTableMetaData(ShardingContext shardingContext, AlterTableStatement alterTableStatement) {
        String tableName = alterTableStatement.getTables().getSingleTableName();
        shardingContext.getMetaData().getTable().put(tableName, this.getTableMetaDataInitializer().load(tableName, shardingContext.getShardingRule()));
    }

    private void refreshTableMetaData(ShardingContext shardingContext, DropTableStatement dropTableStatement) {
        for (String each : dropTableStatement.getTables().getTableNames()) {
            shardingContext.getMetaData().getTable().remove(each);
        }
    }

    private TableMetaDataInitializer getTableMetaDataInitializer() {
        ShardingProperties shardingProperties = this.connection.getShardingContext().getShardingProperties();
        return new TableMetaDataInitializer(this.connection.getShardingContext().getMetaData().getDataSource(), this.connection.getShardingContext().getExecuteEngine(), (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(this.connection.getDataSourceMap()), ((Integer)shardingProperties.getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), ((Boolean)shardingProperties.getValue(ShardingPropertiesConstant.CHECK_TABLE_METADATA_ENABLED)).booleanValue());
    }

    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    protected ShardingConnection getConnection() {
        return this.connection;
    }

    protected SQLExecutePrepareTemplate getSqlExecutePrepareTemplate() {
        return this.sqlExecutePrepareTemplate;
    }

    protected SQLExecuteTemplate getSqlExecuteTemplate() {
        return this.sqlExecuteTemplate;
    }

    protected Collection<Connection> getConnections() {
        return this.connections;
    }

    protected Collection<ShardingExecuteGroup<StatementExecuteUnit>> getExecuteGroups() {
        return this.executeGroups;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public SQLStatement getSqlStatement() {
        return this.sqlStatement;
    }

    public void setSqlStatement(SQLStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
    }

    public List<List<Object>> getParameterSets() {
        return this.parameterSets;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }
}

